/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import crazywoddman.warium_additions.jei.ThermalFurnaceRecipes;
import crazywoddman.warium_additions.jei.WariumJEI;
import crazywoddman.warium_additions.util.WariumAdditionsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;

public class ThermalFurnaceCategory
implements IRecipeCategory<ThermalFurnaceRecipes> {
    public static final RecipeType<ThermalFurnaceRecipes> TYPE = RecipeType.create((String)"crusty_chunks", (String)"thermal_furnace", ThermalFurnaceRecipes.class);
    private final IDrawable background;
    private final IDrawable icon;

    private int ticks() {
        return (int)(System.currentTimeMillis() / 50L);
    }

    private int firebox() {
        return this.ticks() / 20 % 3;
    }

    public ThermalFurnaceCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"textures/screens/ab_gui.png"), 6, 3, 164, 80).setTextureSize(176, 166).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("thermal_furnace"));
    }

    public RecipeType<ThermalFurnaceRecipes> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Thermal Furnace");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ThermalFurnaceRecipes recipe, IFocusGroup focuses) {
        builder.addInputSlot(19, 32).addItemStack(recipe.getInput());
        builder.addOutputSlot(127, 32).addItemStack(recipe.getOutput());
    }

    public void draw(ThermalFurnaceRecipes recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        Random rand;
        int life;
        int age;
        int birthTick;
        int epoch;
        int i;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(70.0f, 0.0f, 0.0f);
        graphics.m_280168_().m_85841_(0.25f, 0.25f, 1.0f);
        graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"warium_additions", (String)(switch (this.firebox()) {
            case 1 -> "textures/jei/thermal_furnace_kerosene.png";
            case 2 -> "textures/jei/thermal_furnace_electric.png";
            default -> "textures/jei/thermal_furnace_firebox.png";
        })), 0, 0, 0.0f, 0.0f, 93, 325, 93, 325);
        graphics.m_280168_().m_85849_();
        for (i = 0; i < 7; ++i) {
            Random rand2 = new Random((long)(this.ticks() / 40) * 1000L + (long)i * 7919L);
            int life2 = 20 + rand2.nextInt(21);
            if (this.ticks() % 40 > life2) continue;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(50 + rand2.nextInt(67)), (float)(40 + rand2.nextInt(41)), 0.0f);
            graphics.m_280168_().m_85841_(1.0f - (float)(this.ticks() % 40) / (float)life2, 1.0f - (float)(this.ticks() % 40) / (float)life2, 1.0f);
            graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/particle/flame.png"), 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
            graphics.m_280168_().m_85849_();
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (i = 0; i < 6; ++i) {
            for (int e = 0; e <= 4; ++e) {
                epoch = this.ticks() / 40 - e;
                birthTick = epoch * 40;
                age = this.ticks() - birthTick;
                if (age < 0 || age > (life = 80 + (rand = new Random((long)epoch * 2000L + (long)i * 12345L)).nextInt(41))) continue;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)(50 + rand.nextInt(57)) + (float)Math.cos((double)rand.nextFloat() * Math.PI * 2.0) * 8.0f + (rand.nextBoolean() ? 1.0f : -1.0f) * rand.nextFloat() * 8.0f * (float)age / (float)life, (float)(40 + rand.nextInt(41)) + (float)Math.sin((double)rand.nextFloat() * Math.PI * 2.0) * 8.0f + (rand.nextBoolean() ? 1.0f : -1.0f) * rand.nextFloat() * 8.0f * (float)age / (float)life, 0.0f);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f - (float)age / (float)life);
                graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("textures/particle/big_smoke_" + rand.nextInt(12) + ".png")), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
        }
        for (i = 0; i < 10; ++i) {
            for (int e = 0; e <= 24; ++e) {
                epoch = this.ticks() / 5 - e;
                birthTick = epoch * 5;
                age = this.ticks() - birthTick;
                if (age < 0 || age > (life = 80 + (rand = new Random((long)epoch * 12345L)).nextInt(41))) continue;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(75.0f + (rand.nextBoolean() ? 1.0f : -1.0f) * rand.nextFloat() * 32.0f * (float)age / (float)life, (float)(-35 + rand.nextInt(25)) + (float)Math.sin((double)rand.nextFloat() * Math.PI * 2.0) * 8.0f + (rand.nextBoolean() ? 1.0f : -1.0f) * rand.nextFloat() * 16.0f * (float)age / (float)life, 0.0f);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f - (float)age / (float)life);
                graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("textures/particle/big_smoke_" + rand.nextInt(12) + ".png")), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                graphics.m_280168_().m_85849_();
            }
        }
        if (mouseX >= 76.0 && mouseX <= 87.0 && mouseY >= 0.0 && mouseY <= 48.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumAdditionsUtil.getWariumStack("blast_funnel"), (int)mouseX, (int)mouseY);
        }
        if (mouseX >= 70.0 && mouseX <= 93.0 && mouseY >= 49.0 && mouseY <= 65.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumAdditionsUtil.getWariumStack("thermal_furnace"), (int)mouseX, (int)mouseY);
        }
        if (mouseX >= 70.0 && mouseX <= 93.0 && mouseY >= 66.0 && mouseY <= 80.0) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.addAll((switch (this.firebox()) {
                case 0 -> WariumAdditionsUtil.getWariumStack("firebox");
                case 1 -> WariumAdditionsUtil.getWariumStack("oil_firebox");
                case 2 -> WariumAdditionsUtil.getWariumStack("electric_firebox");
                default -> WariumAdditionsUtil.getWariumStack("firebox");
            }).m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)));
            tooltip.add(1, Component.m_237113_((String)(switch (this.firebox()) {
                case 0 -> "Must be fueled";
                case 1 -> "Must be fueled";
                case 2 -> "Must be powered";
                default -> "Must be fueled";
            })).m_130940_(ChatFormatting.GOLD));
            graphics.m_280245_(Minecraft.m_91087_().f_91062_, tooltip.stream().map(Component::m_7532_).toList(), (int)mouseX, (int)mouseY);
        }
    }

    public boolean handleInput(ThermalFurnaceRecipes recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && input.m_84873_() == 0 && WariumJEI.jeiRuntime != null) {
            if (mouseX >= 76.0 && mouseX <= 87.0 && mouseY >= 0.0 && mouseY <= 48.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("blast_funnel"))));
                return true;
            }
            if (mouseX >= 70.0 && mouseX <= 93.0 && mouseY >= 49.0 && mouseY <= 65.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumAdditionsUtil.getWariumStack("thermal_furnace"))));
                return true;
            }
            if (mouseX >= 70.0 && mouseX <= 93.0 && mouseY >= 66.0 && mouseY <= 80.0) {
                IRecipesGui iRecipesGui = WariumJEI.jeiRuntime.getRecipesGui();
                IFocusFactory iFocusFactory = WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory();
                iRecipesGui.show(List.of(iFocusFactory.createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)(switch (this.firebox()) {
                    case 0 -> WariumAdditionsUtil.getWariumStack("firebox");
                    case 1 -> WariumAdditionsUtil.getWariumStack("oil_firebox");
                    case 2 -> WariumAdditionsUtil.getWariumStack("electric_firebox");
                    default -> WariumAdditionsUtil.getWariumStack("firebox");
                }))));
                return true;
            }
        }
        return false;
    }
}

