/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.immersiveengineering;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import java.util.EnumMap;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.mcreator.crustychunks.block.entity.EnergyBatteryBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Restriction(require={@Condition(value="immersiveengineering")})
@Mixin(value={EnergyBatteryBlockEntity.class})
public class ImmersiveEnergyBatteryMixin
implements IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IBlockOverlayText {
    public EnumMap<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap(Direction.class);

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void injectEnergyStorage(BlockPos position, BlockState state, CallbackInfo ci) {
        for (Direction direction : DirectionUtils.VALUES) {
            this.sideConfig.put(direction, IEEnums.IOSideConfig.NONE);
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void injectRead(CompoundTag compound, CallbackInfo ci) {
        for (Direction direction : DirectionUtils.VALUES) {
            String key = "sideConfig_" + direction.ordinal();
            if (!compound.m_128441_(key)) continue;
            this.sideConfig.put(direction, IEEnums.IOSideConfig.VALUES[compound.m_128451_(key)]);
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void injectSave(CompoundTag compound, CallbackInfo ci) {
        for (Direction direction : DirectionUtils.VALUES) {
            compound.m_128405_("sideConfig_" + direction.ordinal(), this.sideConfig.get(direction).ordinal());
        }
    }

    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.get(side);
    }

    public boolean toggleSide(Direction side, Player player) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.m_58904_();
        BlockPos pos = blockEntity.m_58899_();
        BlockState state = blockEntity.m_58900_();
        Block block = state.m_60734_();
        this.sideConfig.put(side, IEEnums.IOSideConfig.next((IEEnums.IOSideConfig)this.sideConfig.get(side)));
        blockEntity.m_6596_();
        level.m_7260_(pos, state, state, 3);
        level.m_46672_(pos, block);
        level.m_7696_(pos, block, 0, 0);
        return true;
    }

    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && mop instanceof BlockHitResult) {
            BlockHitResult bmop = (BlockHitResult)mop;
            IEEnums.IOSideConfig here = this.sideConfig.get(bmop.m_82434_());
            IEEnums.IOSideConfig opposite = this.sideConfig.get(bmop.m_82434_().m_122424_());
            return TextUtils.sideConfigWithOpposite((String)"desc.immersiveengineering.info.blockSide.connectEnergy.", (StringRepresentable)here, (StringRepresentable)opposite);
        }
        return null;
    }

    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }
}

