/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.util;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class WariumAdditionsUtil {
    public static ItemStack getWariumStack(String id) {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)id)));
    }

    public static FluidStack getWariumFluid(String id, int amount) {
        return new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)id)), amount);
    }

    public static Ingredient getIngredientTag(String namespace, String id) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id)));
    }

    public static String getFuelType(FluidStack fluidStack) {
        if (fluidStack != null && !fluidStack.isEmpty()) {
            Fluid fluid = fluidStack.getFluid();
            String path = ForgeRegistries.FLUIDS.getKey((Object)fluid).m_135815_();
            for (String fuelType : List.of("diesel", "kerosene")) {
                if (!path.equals(fuelType) && !ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)fuelType))).contains((Object)fluid)) continue;
                return fuelType;
            }
        }
        return "";
    }

    public static boolean compareFluids(Fluid first, Fluid second) {
        String secondPath;
        if (first.equals(second)) {
            return true;
        }
        String firstPath = ForgeRegistries.FLUIDS.getKey((Object)first).m_135815_();
        return firstPath.equals(secondPath = ForgeRegistries.FLUIDS.getKey((Object)second).m_135815_()) || ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)firstPath))).contains((Object)second) || ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)secondPath))).contains((Object)first);
    }

    public static String formatSeconds(int totalSeconds) {
        int seconds = totalSeconds % 60;
        if (totalSeconds >= 3600) {
            int hours = totalSeconds / 3600;
            int minutes = totalSeconds % 3600 / 60;
            return String.format("%d:%02d:%02d", hours, minutes, seconds);
        }
        int minutes = totalSeconds / 60;
        return String.format("%d:%02d", minutes, seconds);
    }

    public static String formatFE(int fe) {
        if (fe >= 1000000000) {
            return (double)Math.round(fe / 100000000) / 10.0 + "Gfe";
        }
        if (fe >= 1000000) {
            return (double)Math.round(fe / 100000) / 10.0 + "Mfe";
        }
        if (fe >= 1000) {
            return (double)Math.round(fe / 100) / 10.0 + "Kfe";
        }
        return fe + "fe";
    }
}

