/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.create;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import crazywoddman.warium_additions.util.WariumAdditionsUtil;
import java.util.List;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.mcreator.crustychunks.block.entity.BreederReactorInterfaceBlockEntity;
import net.mcreator.crustychunks.block.entity.CentrifugeCoreBlockEntity;
import net.mcreator.crustychunks.init.CrustyChunksModBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;

@Restriction(require={@Condition(value="create", versionPredicates={"[0.5.1.j]"})})
@Mixin(value={BreederReactorInterfaceBlockEntity.class, CentrifugeCoreBlockEntity.class})
public abstract class ProcesstimeTooltipProvider
implements IHaveGoggleInformation {
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockEntity blockEntity = (BlockEntity)this;
        boolean isReactor = blockEntity instanceof BreederReactorInterfaceBlockEntity;
        if (ProcesstimeTooltipProvider.structureComplete(blockEntity, blockEntity.m_58899_(), isReactor)) {
            boolean validItem = false;
            int itemsAmount = 0;
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                for (int i = 0; i < container.m_6643_(); ++i) {
                    ItemStack stack = container.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    validItem = stack.m_204117_(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"warium_additions", (String)(isReactor ? "reactor_acceptable" : "enrichable"))));
                    itemsAmount = stack.m_41613_();
                    break;
                }
            }
            if (validItem) {
                CompoundTag data = blockEntity.getPersistentData();
                int enrichmentTime = data.m_128451_("enrichmentTimeGamerule");
                int timeLeft = (enrichmentTime * (isReactor ? 2 : 1) - data.m_128451_("T")) / 4;
                int timeLeftover = enrichmentTime / (isReactor ? 2 : 4) * (itemsAmount - 1);
                tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)(isReactor ? "block.crusty_chunks.breeder_reactor_interface" : "block.crusty_chunks.centrifuge_core"))).m_7220_((Component)Component.m_237113_((String)":")).m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)(isReactor ? "warium_additions.breeder_reactor.processtime" : "gamerule.enrichmentTime"))).m_7220_((Component)Component.m_237113_((String)": ")).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237113_((String)WariumAdditionsUtil.formatSeconds(timeLeft)).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)(timeLeftover > 0 ? " + " + WariumAdditionsUtil.formatSeconds(timeLeftover) : "")).m_130940_(ChatFormatting.DARK_GRAY)));
                return true;
            }
        }
        return false;
    }

    private static boolean getReady(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity != null && blockEntity.getPersistentData().m_128471_("Ready");
    }

    private static boolean structureComplete(BlockEntity blockEntity, BlockPos pos, boolean isReactor) {
        Level level = blockEntity.m_58904_();
        if (!isReactor) {
            return ProcesstimeTooltipProvider.getReady(level, pos.m_7494_());
        }
        return level.m_8055_(pos.m_6625_(2)).m_60734_() == CrustyChunksModBlocks.BREEDER_REACTOR_PORT.get() && level.m_8055_(pos.m_6625_(1)).m_60734_() == CrustyChunksModBlocks.BREEDER_REACTOR_CORE.get() && ProcesstimeTooltipProvider.getReady(level, pos.m_6625_(1).m_122013_(2)) && ProcesstimeTooltipProvider.getReady(level, pos.m_6625_(1).m_122020_(2)) && ProcesstimeTooltipProvider.getReady(level, pos.m_6625_(1).m_122025_(2)) && ProcesstimeTooltipProvider.getReady(level, pos.m_6625_(1).m_122030_(2)) && ProcesstimeTooltipProvider.getReady(level, pos.m_122013_(2)) && ProcesstimeTooltipProvider.getReady(level, pos.m_122020_(2)) && ProcesstimeTooltipProvider.getReady(level, pos.m_122025_(2)) && ProcesstimeTooltipProvider.getReady(level, pos.m_122030_(2));
    }
}

