/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.crusty_chunks;

import crazywoddman.warium_additions.config.Config;
import crazywoddman.warium_additions.util.ThrottleProvider;
import net.mcreator.crustychunks.procedures.EngineCyllinderOnTickUpdateProcedure;
import net.mcreator.crustychunks.procedures.EngineUpdateProcedure;
import net.mcreator.crustychunks.procedures.PetrolEngineUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EngineUpdateProcedure.class, PetrolEngineUpdateProcedure.class, EngineCyllinderOnTickUpdateProcedure.class})
public class EnginesUpdateProcedureMixin {
    private static String engineType;

    @Inject(method={"execute"}, at={@At(value="HEAD")}, remap=false, require=0)
    private static void injectEnginesExecute(LevelAccessor world, double x, double y, double z, CallbackInfo ci) {
        engineType = ForgeRegistries.BLOCKS.getKey((Object)world.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_60734_()).m_135815_();
    }

    @ModifyConstant(method={"execute"}, constant={@Constant(stringValue="Diesel")}, require=0, remap=false)
    private static String modifyDiesel(String value) {
        return "";
    }

    @ModifyConstant(method={"execute"}, constant={@Constant(stringValue="Petrol")}, require=0, remap=false)
    private static String modifyPetrol(String value) {
        return "";
    }

    @ModifyConstant(method={"execute"}, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelAccessor;isClientSide()Z", ordinal=0, remap=true))}, constant={@Constant(doubleValue=50.0)}, remap=false, require=0)
    private static double modifyPowerMediumDiesel(double value) {
        return ((Integer)Config.SERVER.mediumDieselEnginePower.get()).intValue();
    }

    @ModifyConstant(method={"execute"}, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelAccessor;isClientSide()Z", ordinal=0, remap=true))}, constant={@Constant(doubleValue=35.0)}, remap=false, require=0)
    private static double modifyPowerSmallDiesel(double value) {
        return ((Integer)Config.SERVER.smallDieselEnginePower.get()).intValue();
    }

    @ModifyConstant(method={"execute"}, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelAccessor;isClientSide()Z", ordinal=0, remap=true))}, constant={@Constant(doubleValue=60.0)}, remap=false, require=0)
    private static double modifyPowerMediumPetrol(double value) {
        return ((Integer)Config.SERVER.mediumPetrolEnginePower.get()).intValue();
    }

    @ModifyConstant(method={"execute"}, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelAccessor;isClientSide()Z", ordinal=0, remap=true))}, constant={@Constant(doubleValue=40.0)}, remap=false, require=0)
    private static double modifyPowerSmallPetrol(double value) {
        return ((Integer)Config.SERVER.smallPetrolEnginePower.get()).intValue();
    }

    @ModifyConstant(method={"execute"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/LevelAccessor;isClientSide()Z", ordinal=0, remap=true))}, constant={@Constant(doubleValue=50.0)}, remap=false, require=0)
    private static double modifyPowerLargeEngine(double value, LevelAccessor world, double x, double y, double z) {
        return ((Integer)Config.SERVER.largeEnginePower.get()).intValue();
    }

    @ModifyConstant(method={"execute"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;sendBlockUpdated(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;I)V", ordinal=0, remap=true))}, constant={@Constant(doubleValue=0.0, ordinal=0)}, remap=false)
    private static double modifyFirstZero(double power, LevelAccessor world, double x, double y, double z) {
        return ((Integer)Config.SERVER.maxThrottle.get()).intValue();
    }

    @ModifyConstant(method={"execute"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;sendBlockUpdated(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;I)V", ordinal=0, remap=true))}, constant={@Constant(doubleValue=0.0, ordinal=1)}, remap=false)
    private static double modifySecondZero(double power, LevelAccessor world, double x, double y, double z) {
        int throttle = ThrottleProvider.get(world.m_7702_(BlockPos.m_274561_((double)x, (double)y, (double)z)), 0);
        double maxPower = switch (engineType) {
            case "light_combustion_engine" -> ((Integer)Config.SERVER.mediumDieselEnginePower.get()).intValue();
            case "small_diesel_engine" -> ((Integer)Config.SERVER.smallDieselEnginePower.get()).intValue();
            case "medium_petrol_engine" -> ((Integer)Config.SERVER.mediumPetrolEnginePower.get()).intValue();
            case "smal_petrol_engine" -> ((Integer)Config.SERVER.mediumDieselEnginePower.get()).intValue();
            case "engine_cyllinder" -> ((Integer)Config.SERVER.largeEnginePower.get()).intValue();
            default -> 0.0;
        };
        return throttle == 0 ? 0.0 : maxPower / (double)((Integer)Config.SERVER.maxThrottle.get()).intValue() * (double)Math.abs(throttle);
    }
}

