/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.crusty_chunks.energy;

import crazywoddman.warium_additions.config.Config;
import net.mcreator.crustychunks.block.LargeElectricMotorBlock;
import net.mcreator.crustychunks.block.entity.LargeElectricMotorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LargeElectricMotorBlockEntity.class})
public class LargeElectricMotorBlockMixin {
    @Unique
    private EnergyStorage energyStorage;
    private final int transLimit;

    public LargeElectricMotorBlockMixin() {
        this.transLimit = (Integer)Config.SERVER.energyTransferLimit.get();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void injectEnergyStorage(final BlockPos pos, BlockState state, CallbackInfo ci) {
        final BlockEntity blockEntity = (BlockEntity)this;
        this.energyStorage = new EnergyStorage(this.transLimit, this.transLimit, 0){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int receive;
                int n = receive = blockEntity.m_58904_().m_276867_(pos) ? 0 : Math.min(LargeElectricMotorBlockMixin.this.transLimit, maxReceive);
                if (!simulate) {
                    this.energy = receive;
                }
                return receive;
            }
        };
    }

    @Redirect(method={"load"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/energy/EnergyStorage;deserializeNBT(Lnet/minecraft/nbt/Tag;)V", remap=false))
    private void redirectDeserializeNBT(EnergyStorage storage, Tag tag) {
        this.energyStorage.deserializeNBT(tag);
    }

    @Redirect(method={"saveAdditional"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;put(Ljava/lang/String;Lnet/minecraft/nbt/Tag;)Lnet/minecraft/nbt/Tag;"))
    private Tag redirectCompoundPut(CompoundTag compound, String key, Tag tag) {
        compound.m_128365_("energyStorage", this.energyStorage.serializeNBT());
        if (this.energyStorage.getEnergyStored() > 0) {
            this.energyStorage.receiveEnergy(0, false);
        }
        return new CompoundTag();
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectEnergyCapability(Capability<?> capability, Direction facing, CallbackInfoReturnable<LazyOptional<?>> cir) {
        if (capability == ForgeCapabilities.ENERGY && (facing == null || facing == ((Direction)((BlockEntity)this).m_58900_().m_61143_((Property)LargeElectricMotorBlock.FACING)).m_122424_())) {
            cir.setReturnValue((Object)LazyOptional.of(() -> this.energyStorage).cast());
        }
    }
}

