/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.tfmg;

import com.drmangotea.tfmg.blocks.engines.compact.CompactEngineBlockEntity;
import com.drmangotea.tfmg.blocks.engines.low_grade_fuel.LowGradeFuelEngineBlockEntity;
import com.drmangotea.tfmg.blocks.engines.radial.RadialEngineBlockEntity;
import com.drmangotea.tfmg.blocks.engines.small.AbstractEngineBlockEntity;
import crazywoddman.warium_additions.config.Config;
import crazywoddman.warium_additions.util.ThrottleProvider;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Restriction(require={@Condition(value="tfmg", versionPredicates={"[0.9.3]"})})
@Mixin(value={AbstractEngineBlockEntity.class, CompactEngineBlockEntity.class, LowGradeFuelEngineBlockEntity.class, RadialEngineBlockEntity.class}, remap=false)
public class EnginesThrottleControl {
    @Shadow(remap=false)
    int signal;
    private final int maxThrottle;
    private final boolean throttleToRotationDirection;
    private int lastSignal;
    private int lastRedstoneSignal;

    public EnginesThrottleControl() {
        this.maxThrottle = (Integer)Config.SERVER.maxThrottle.get();
        this.throttleToRotationDirection = (Boolean)Config.SERVER.throttleToRotationDirection.get();
    }

    @Inject(method={"analogSignalChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void analogSignalChangedTweak(int newSignal, CallbackInfo ci) {
        this.lastRedstoneSignal = newSignal;
        ci.cancel();
    }

    @Inject(method={"getGeneratedSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectReturn(CallbackInfoReturnable<Float> cir) {
        float originalValue = ((Float)cir.getReturnValue()).floatValue();
        if (originalValue != 0.0f && this.throttleToRotationDirection && this.lastSignal < 0) {
            cir.setReturnValue((Object)Float.valueOf(-1.0f * originalValue));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void injectSignalTick(CallbackInfo ci) {
        int throttle;
        BlockEntity blockEntity = (BlockEntity)this;
        if (blockEntity.m_58904_().m_46467_() % 8L != 0L) {
            return;
        }
        int newSignal = this.lastRedstoneSignal;
        if (this.lastRedstoneSignal == 0 && (throttle = ThrottleProvider.get(blockEntity, 0).intValue()) != 0) {
            newSignal = Math.round(15.0f / (float)this.maxThrottle * (float)throttle);
        }
        if (this.lastSignal != newSignal) {
            this.lastSignal = newSignal;
            this.signal = Math.abs(newSignal);
        }
    }
}

