/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import crazywoddman.warium_additions.WariumPonder;
import crazywoddman.warium_additions.compat.create.CreateBlockEntities;
import crazywoddman.warium_additions.compat.create.CreateBlocks;
import crazywoddman.warium_additions.compat.create.CreateFluids;
import crazywoddman.warium_additions.compat.create.CreateItems;
import crazywoddman.warium_additions.compat.create.Registrate;
import crazywoddman.warium_additions.compat.curios.CuriosEvents;
import crazywoddman.warium_additions.compat.curios.CuriosUtil;
import crazywoddman.warium_additions.config.ClothConfig;
import crazywoddman.warium_additions.config.Config;
import crazywoddman.warium_additions.network.LaunchKeyPacket;
import crazywoddman.warium_additions.network.NetworkHandler;
import crazywoddman.warium_additions.network.ShootKeyPacket;
import crazywoddman.warium_additions.recipe.WariumAdditionsRecipeTypes;
import crazywoddman.warium_additions.registry.RegistryBlockEntities;
import crazywoddman.warium_additions.registry.RegistryBlocks;
import crazywoddman.warium_additions.registry.RegistryItems;
import net.mcreator.crustychunks.init.CrustyChunksModItems;
import net.mcreator.crustychunks.procedures.Rad1TickProcedure;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="warium_additions")
public class WariumAdditions {
    public static final String MODID = "warium_additions";
    private static final ModList modlist = ModList.get();
    public static final boolean cloth_config = modlist.isLoaded("cloth_config");
    public static final boolean curios = modlist.isLoaded("curios");
    public static final boolean supplementaries = modlist.isLoaded("supplementaries");
    public static final boolean valkyrien_warium = modlist.isLoaded("valkyrien_warium");
    public static final boolean immersiveengineering = modlist.isLoaded("immersiveengineering");
    public static final boolean create = modlist.getModContainerById("create").map(container -> container.getModInfo().getVersion().toString().equals("0.5.1.j")).orElse(false);

    public WariumAdditions(FMLJavaModLoadingContext context) {
        IEventBus bus = context.getModEventBus();
        RegistryBlocks.WARIUM_REGISTRY.register(bus);
        RegistryItems.WARIUM_REGISTRY.register(bus);
        if (cloth_config) {
            context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
        }
        if (create || supplementaries) {
            WariumAdditionsRecipeTypes.register();
            WariumAdditionsRecipeTypes.Recipes.SERIALIZER_REGISTER.register(bus);
            WariumAdditionsRecipeTypes.Recipes.TYPE_REGISTER.register(bus);
        }
        if (modlist.isLoaded("valkyrien_warium")) {
            RegistryItems.REGISTRY.register(bus);
            RegistryBlocks.REGISTRY.register(bus);
            RegistryBlocks.OLD_REGISTRY.register(bus);
            RegistryBlockEntities.REGISTRY.register(bus);
            RegistryBlockEntities.OLD_REGISTRY.register(bus);
        }
        if (create) {
            Registrate.register(bus);
            CreateBlocks.register();
            CreateBlockEntities.register();
            CreateItems.register();
            CreateFluids.register();
        }
        if (curios) {
            NetworkHandler.register();
            MinecraftForge.EVENT_BUS.register(CuriosEvents.class);
        }
    }

    @Mod.EventBusSubscriber(modid="warium_additions", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
            if (create && event.getItemStack().m_150930_((Item)CreateItems.YELLOWCAKE.get())) {
                event.setBurnTime(12800);
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            BlockPos pos;
            Player player;
            Level level;
            if (create && (level = (player = event.player).m_9236_()).m_6425_(pos = player.m_20183_()).m_76152_() == ((ForgeFlowingFluid.Flowing)CreateFluids.YELLOWCAKE_FLUID.get()).m_5613_() && player.f_19797_ % 10 == 0) {
                Rad1TickProcedure.execute((LevelAccessor)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="warium_additions", value={Dist.CLIENT})
    public class ClientKeyEvents {
        private static final ResourceLocation BARREL_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"warium_additions", (String)"textures/gui/barrel.png");

        private static void playDrySound(Player player) {
            player.m_9236_().m_5594_(player, player.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"dryfire")), SoundSource.NEUTRAL, 1.0f, Mth.m_216267_((RandomSource)RandomSource.m_216327_(), (float)0.9f, (float)1.1f));
        }

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (curios) {
                if (ClientEvents.SHOOT_KEY.m_90859_()) {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    CuriosUtil.getItem((LivingEntity)player, "head", (Item)CrustyChunksModItems.LIGHT_MACHINE_GUN.get()).ifPresent(s -> CuriosUtil.getItem((LivingEntity)player, "ammobox", (Item)CrustyChunksModItems.MACHINE_GUN_BOX.get()).ifPresentOrElse(stack -> {
                        if (stack.m_41784_().m_128451_("AmmoSize") == -1 && stack.m_41784_().m_128451_("Ammo") > 0) {
                            NetworkHandler.CHANNEL.sendToServer((Object)new ShootKeyPacket());
                        } else {
                            ClientKeyEvents.playDrySound((Player)player);
                        }
                    }, () -> ClientKeyEvents.playDrySound((Player)player)));
                }
                if (ClientEvents.LAUNCH_KEY.m_90859_()) {
                    NetworkHandler.CHANNEL.sendToServer((Object)new LaunchKeyPacket());
                }
            }
        }

        @SubscribeEvent
        public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Pre event) {
            if (curios) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null && mc.f_91066_.m_92176_().m_90612_() && CuriosUtil.getItem((LivingEntity)mc.f_91074_, "head", (Item)CrustyChunksModItems.LIGHT_MACHINE_GUN.get()).isPresent()) {
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.enableBlend();
                    GuiGraphics guiGraphics = event.getGuiGraphics();
                    int screenWidth = guiGraphics.m_280182_();
                    int screenHeight = guiGraphics.m_280206_();
                    int size = Math.max(screenWidth, screenHeight);
                    int offsetX = (screenWidth - size) / 2;
                    int offsetY = (screenHeight - size) / 2;
                    guiGraphics.m_280398_(BARREL_OVERLAY, offsetX, offsetY, -90, 0.0f, 0.0f, size, size, size, size);
                    RenderSystem.disableBlend();
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.enableDepthTest();
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="warium_additions", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        public static KeyMapping SHOOT_KEY;
        public static KeyMapping LAUNCH_KEY;

        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            if (curios) {
                SHOOT_KEY = new KeyMapping("key.warium_additions.shoot", InputConstants.Type.KEYSYM, 82, "key.categories.warium_additions");
                LAUNCH_KEY = new KeyMapping("key.warium_additions.launch", InputConstants.Type.KEYSYM, 82, "key.categories.warium_additions");
                event.register(SHOOT_KEY);
                event.register(LAUNCH_KEY);
            }
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            if (curios) {
                CuriosUtil.registerBeltRenderers(new Item[]{(Item)CrustyChunksModItems.ENERGY_METER.get(), (Item)CrustyChunksModItems.GEIGER_COUNTER.get()});
                CuriosUtil.registerHeadRenderers(new Item[]{(Item)CrustyChunksModItems.LIGHT_MACHINE_GUN.get()});
                CuriosUtil.registerSpecialRenderers();
                CuriosUtil.registerHardpointRenderers(new Item[]{(Item)CrustyChunksModItems.EMPTY_MISSILE_HARDPOINT.get(), (Item)CrustyChunksModItems.FIRE_SPEAR_ROCKET.get(), (Item)CrustyChunksModItems.SEEKER_SPEAR_ROCKET.get(), (Item)CrustyChunksModItems.RADAR_SPEAR_MISSILE.get(), (Item)CrustyChunksModItems.STRIKE_SPEAR_MISSILE.get()});
            }
            if (modlist.isLoaded("cloth_config")) {
                ClothConfig.registerConfigScreen();
            }
            if (modlist.isLoaded("ponderjs")) {
                WariumPonder.kubeJSreloadScripts(event);
            }
        }

        @SubscribeEvent
        public static void onBuildCreativeTab(BuildCreativeModeTabContentsEvent event) {
            if (create) {
                if (event.getTabKey().m_135782_().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"warium_logistics"))) {
                    event.m_246342_(CreateBlocks.KINETIC_CONVERTER.asStack());
                    event.m_246342_(CreateBlocks.ROTATION_CONVERTER.asStack());
                }
                if (event.getTabKey().m_135782_().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"crusty_production"))) {
                    event.m_246326_((ItemLike)CreateItems.YELLOWCAKE.get());
                }
                if (event.getTabKey().m_135782_().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"crusty_components"))) {
                    event.m_246326_((ItemLike)CreateItems.PETROLIUM_BOTTLE.get());
                    event.m_246326_((ItemLike)CreateFluids.YELLOWCAKE_FLUID.getBucket().get());
                }
            }
            if (valkyrien_warium && event.getTabKey().m_135782_().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"valkyrien_warium", (String)"warium_vs"))) {
                event.accept(RegistryItems.CONTROLLABLE_TRIGGER);
            }
        }
    }
}

