/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.compat.create.blocks.converters;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import crazywoddman.warium_additions.compat.create.blocks.converters.KineticConverterBlock;
import crazywoddman.warium_additions.config.Config;
import crazywoddman.warium_additions.util.ThrottleProvider;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class KineticConverterBlockEntity
extends GeneratingKineticBlockEntity {
    private final int defaultStress;
    private final int defaultSpeed;
    private final int maxThrottle;
    private final int kineticConverterReponse;
    private boolean converterSpeedControl;
    private final boolean throttleToRotationDirection;
    private int lastThrottle;
    private double lastKineticPower;
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public ScrollValueBehaviour generatedSpeed;

    public KineticConverterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.defaultStress = (Integer)Config.SERVER.kineticToStressRatio.get();
        this.defaultSpeed = (Integer)Config.SERVER.kineticToSpeedRatio.get();
        this.maxThrottle = (Integer)Config.SERVER.maxThrottle.get();
        this.kineticConverterReponse = (Integer)Config.SERVER.kineticConverterReponse.get();
        this.converterSpeedControl = (Boolean)Config.SERVER.converterSpeedControl.get();
        this.throttleToRotationDirection = (Boolean)Config.SERVER.throttleToRotationDirection.get();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.converterSpeedControl = (Boolean)Config.SERVER.converterSpeedControl.get();
        if (this.converterSpeedControl) {
            this.generatedSpeed = new KineticScrollValueBehaviour((Component)Lang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ValueBox());
            this.generatedSpeed.between(-256, 256);
            this.generatedSpeed.value = this.defaultSpeed * 50;
            this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
            behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
        } else {
            this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)Lang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ValueBox());
            this.movementDirection.withCallback(i -> this.updateGeneratedRotation());
            behaviours.add((BlockEntityBehaviour)this.movementDirection);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        int savedValue;
        super.read(compound, clientPacket);
        if (!this.converterSpeedControl && compound.m_128441_("ScrollValue")) {
            savedValue = compound.m_128451_("ScrollValue");
            if (savedValue < 0) {
                compound.m_128405_("ScrollValue", 0);
                if (this.movementDirection != null) {
                    this.movementDirection.setValue(0);
                }
            } else if (savedValue >= WindmillBearingBlockEntity.RotationDirection.values().length) {
                compound.m_128405_("ScrollValue", 1);
                if (this.movementDirection != null) {
                    this.movementDirection.setValue(1);
                }
            }
        }
        if (this.converterSpeedControl && compound.m_128441_("ScrollValue") && (savedValue = compound.m_128451_("ScrollValue")) == 0) {
            compound.m_128405_("ScrollValue", 100);
            if (this.generatedSpeed != null) {
                this.generatedSpeed.setValue(100);
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.updateGeneratedRotation();
    }

    public float getGeneratedSpeed() {
        float speed;
        if (this.lastKineticPower <= 0.0 || this.lastThrottle == 0) {
            return 0.0f;
        }
        if (this.converterSpeedControl && this.generatedSpeed != null) {
            speed = this.generatedSpeed.getValue();
        } else if (this.movementDirection != null) {
            speed = (float)(this.defaultSpeed * (this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.CLOCKWISE ? -1 : 1)) * (float)this.lastKineticPower;
        } else {
            return 0.0f;
        }
        return KineticConverterBlockEntity.convertToDirection((float)(speed / (float)this.maxThrottle * (float)(this.throttleToRotationDirection ? this.lastThrottle : Math.abs(this.lastThrottle))), (Direction)((Direction)this.m_58900_().m_61143_((Property)KineticConverterBlock.FACING)));
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)this.defaultStress / (float)this.defaultSpeed;
        return capacity;
    }

    public void tick() {
        boolean throttleChanged;
        boolean powerChanged;
        CompoundTag backData;
        super.tick();
        if (this.f_58857_.m_46467_() % (long)this.kineticConverterReponse != 0L) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)KineticConverterBlock.FACING);
        BlockPos backPos = this.m_58899_().m_121945_(facing.m_122424_());
        BlockState backState = this.f_58857_.m_8055_(backPos);
        BlockEntity backBlockEntity = this.f_58857_.m_7702_(backPos);
        Double newKineticPower = 0.0;
        int newThrottle = 0;
        if (backBlockEntity != null && (backData = backBlockEntity.getPersistentData()).m_128441_("KineticPower")) {
            DirectionProperty facingProp = null;
            for (Property property : backState.m_61147_()) {
                DirectionProperty directionProperty;
                if (!(property instanceof DirectionProperty)) continue;
                facingProp = directionProperty = (DirectionProperty)property;
                break;
            }
            if (facingProp != null && backState.m_61143_(facingProp) == facing) {
                newKineticPower = backData.m_128459_("KineticPower");
                newThrottle = ThrottleProvider.get((BlockEntity)this, this.maxThrottle);
            }
        }
        boolean bl = powerChanged = this.lastKineticPower != newKineticPower;
        if (powerChanged) {
            this.lastKineticPower = newKineticPower;
        }
        boolean bl2 = throttleChanged = this.lastThrottle != newThrottle;
        if (throttleChanged) {
            this.lastThrottle = newThrottle;
        }
        if (powerChanged || throttleChanged) {
            this.updateGeneratedRotation();
        }
    }

    class ValueBox
    extends ValueBoxTransform.Sided {
        ValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)14.5);
        }

        public Vec3 getLocalOffset(BlockState state) {
            return super.getLocalOffset(state).m_82549_(Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)KineticConverterBlock.FACING)).m_122436_()).m_82490_(0.125));
        }

        public void rotate(BlockState state, PoseStack ms) {
            super.rotate(state, ms);
            Direction facing = (Direction)state.m_61143_((Property)KineticConverterBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.cast((PoseStack)ms).rotateZ((double)(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f));
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)KineticConverterBlock.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && direction == Direction.DOWN) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

