/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.compat.curios;

import com.google.common.collect.ImmutableMultimap;
import crazywoddman.warium_additions.WariumAdditions;
import java.util.UUID;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioEquipEvent;
import top.theillusivec4.curios.api.event.CurioUnequipEvent;

public class CuriosEvents {
    private static final ImmutableMultimap<String, AttributeModifier> HARDPOINT_SLOT_MAP = ImmutableMultimap.of((Object)"hardpoint", (Object)new AttributeModifier(UUID.fromString("14881488-1488-1488-1488-148814881488"), "Hardpoint", 1.0, AttributeModifier.Operation.ADDITION));
    private static final ImmutableMultimap<String, AttributeModifier> AMMOBOX_SLOT_MAP = ImmutableMultimap.of((Object)"ammobox", (Object)new AttributeModifier(UUID.fromString("69696969-6969-6969-6969-696969696969"), "Ammobox", 1.0, AttributeModifier.Operation.ADDITION));

    @SubscribeEvent
    public static Event.Result onCurioEquip(CurioEquipEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlotContext().identifier().equals("hardpoint")) {
                if (player instanceof LocalPlayer) {
                    LocalPlayer localPlayer = (LocalPlayer)player;
                    localPlayer.m_5661_((Component)Component.m_237115_((String)"warium_additions.tooltip.presskey").m_130946_(" " + WariumAdditions.ClientEvents.LAUNCH_KEY.getKey().m_84875_().getString() + " ").m_7220_((Component)Component.m_237115_((String)"warium_additions.tooltip.launch_missile")), true);
                }
                player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.m_135820_((String)"block.iron_trapdoor.open")), SoundSource.NEUTRAL, 1.0f, 0.3f, false);
            } else {
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inventory -> {
                    switch (ForgeRegistries.ITEMS.getKey((Object)event.getStack().m_41720_()).m_135815_()) {
                        case "light_machine_gun": {
                            inventory.addTransientSlotModifiers(AMMOBOX_SLOT_MAP);
                            break;
                        }
                        case "empty_missile_hardpoint": {
                            inventory.addTransientSlotModifiers(HARDPOINT_SLOT_MAP);
                            break;
                        }
                        case "machine_gun_box": {
                            CuriosEvents.playAmmoboxEquipSound(player);
                            if (!(player instanceof LocalPlayer)) break;
                            LocalPlayer localPlayer = (LocalPlayer)player;
                            localPlayer.m_5661_((Component)Component.m_237115_((String)"warium_additions.tooltip.presskey").m_130946_(" " + WariumAdditions.ClientEvents.SHOOT_KEY.getKey().m_84875_().getString() + " ").m_7220_((Component)Component.m_237115_((String)"warium_additions.tooltip.shoot")), true);
                        }
                    }
                });
            }
        }
        return event.getResult();
    }

    @SubscribeEvent
    public static Event.Result onCurioUnequip(CurioUnequipEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlotContext().identifier().equals("hardpoint")) {
                player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.m_135820_((String)"block.iron_trapdoor.open")), SoundSource.NEUTRAL, 1.0f, 0.3f, false);
            } else {
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inventory -> {
                    switch (ForgeRegistries.ITEMS.getKey((Object)event.getStack().m_41720_()).m_135815_()) {
                        case "light_machine_gun": {
                            inventory.removeSlotModifiers(AMMOBOX_SLOT_MAP);
                            break;
                        }
                        case "empty_missile_hardpoint": {
                            inventory.removeSlotModifiers(HARDPOINT_SLOT_MAP);
                            break;
                        }
                        case "machine_gun_box": {
                            CuriosEvents.playAmmoboxEquipSound(player);
                        }
                    }
                });
            }
        }
        return event.getResult();
    }

    private static void playAmmoboxEquipSound(Player player) {
        player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)"pistolaction")), SoundSource.NEUTRAL, 1.0f, 0.8f, false);
    }
}

