/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.config;

import crazywoddman.warium_additions.WariumAdditions;
import crazywoddman.warium_additions.config.Config;
import java.util.ArrayList;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClothConfig {
    public static void registerConfigScreen() {
        FMLJavaModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle((Component)Component.m_237113_((String)"Warium Additions Config"));
            builder.setGlobalized(false);
            builder.setTransparentBackground(true);
            ArrayList<ConfigCategory> categories = new ArrayList<ConfigCategory>(3);
            categories.add(builder.getOrCreateCategory((Component)Component.m_237113_((String)"Warium")));
            if (WariumAdditions.valkyrien_warium) {
                ConfigCategory valkyrien = builder.getOrCreateCategory((Component)Component.m_237113_((String)"Valkyrien Warium"));
                categories.add(valkyrien);
            }
            if (WariumAdditions.create) {
                ConfigCategory create = builder.getOrCreateCategory((Component)Component.m_237113_((String)"Create"));
                categories.add(create);
            }
            ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
            String levelType = Minecraft.m_91087_().f_91073_ == null ? "null" : (Minecraft.m_91087_().m_91092_() == null ? "client" : "host");
            for (ConfigCategory category : categories) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)("\u00a7eChanges " + (switch (levelType) {
                    case "null" -> "can't be made from the main menu. Enter a world";
                    case "host" -> "only apply for the current world. Re-enter the world for some changes to take effect";
                    case "client" -> "on server can only be made by editing config file in world/serverconfig/. Alternatively, you can use Create \u00abAccess Configs of other mods\u00bb feature. Server restart is required for some changes to apply";
                    default -> "can't be made due to unknown error";
                })))).build());
                if (!levelType.equals("host")) continue;
                ClothConfig.addCategory(category, entryBuilder);
            }
            return builder.build();
        }));
    }

    private static void addCategory(ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        switch (category.getCategoryKey().getString()) {
            case "Warium": {
                SubCategoryBuilder fluidcap = entryBuilder.startSubCategory((Component)Component.m_237113_((String)"Fluid Capacities"));
                fluidcap.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Fluid capacity of fuel tanks (mB)"), ((Integer)Config.SERVER.fuelTanksCapacity.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.fuelTanksCapacity.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.fuelTanksCapacity.set(newValue)).build());
                fluidcap.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Fluid capacity of Refinery Tower (mB)"), ((Integer)Config.SERVER.refineryTowerCapacity.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.refineryTowerCapacity.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.refineryTowerCapacity.set(newValue)).build());
                fluidcap.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Fluid capacity of Kerosene Firebox (mB)"), ((Integer)Config.SERVER.oilFireboxCapacity.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.oilFireboxCapacity.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.oilFireboxCapacity.set(newValue)).build());
                fluidcap.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Fluid capacity of Block Miner (mB)"), ((Integer)Config.SERVER.blockMinerCapacity.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.blockMinerCapacity.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.blockMinerCapacity.set(newValue)).build());
                category.addEntry((AbstractConfigListEntry)fluidcap.build());
                SubCategoryBuilder power = entryBuilder.startSubCategory((Component)Component.m_237113_((String)"Engines Power"));
                power.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Medium Diesel Engine power"), ((Integer)Config.SERVER.mediumDieselEnginePower.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.mediumDieselEnginePower.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.mediumDieselEnginePower.set(newValue)).build());
                power.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Small Diesel Engine power"), ((Integer)Config.SERVER.smallDieselEnginePower.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.smallDieselEnginePower.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.smallDieselEnginePower.set(newValue)).build());
                power.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Medium Petrol Engine power"), ((Integer)Config.SERVER.mediumPetrolEnginePower.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.mediumPetrolEnginePower.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.mediumPetrolEnginePower.set(newValue)).build());
                power.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Small Petrol Engine power"), ((Integer)Config.SERVER.smallPetrolEnginePower.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.smallPetrolEnginePower.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.smallPetrolEnginePower.set(newValue)).build());
                power.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Jet Turbine power"), ((Integer)Config.SERVER.turbinePower.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.turbinePower.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.turbinePower.set(newValue)).build());
                category.addEntry((AbstractConfigListEntry)power.build());
                SubCategoryBuilder energy = entryBuilder.startSubCategory((Component)Component.m_237113_((String)"Energy"));
                energy.add((AbstractConfigListEntry)((DoubleFieldBuilder)entryBuilder.startDoubleField((Component)Component.m_237113_((String)"How much Forge Energy = 1 Kinetic Power unit"), ((Double)Config.SERVER.kineticToFeRate.get()).doubleValue()).setTooltip(new Component[]{Component.m_237113_((String)"This affects Rotation Generator and Electric Motor")}).setDefaultValue((Object)((Double)Config.SERVER.kineticToFeRate.getDefault()))).setMin(0.01).setSaveConsumer(newValue -> Config.SERVER.kineticToFeRate.set(newValue)).build());
                energy.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Energy transfer limit"), ((Integer)Config.SERVER.energyTransferLimit.get()).intValue()).setTooltip(new Component[]{Component.m_237113_((String)"Maximum amount of energy that can be transfered to/from Warium blocks per tick")}).setDefaultValue((Object)((Integer)Config.SERVER.energyTransferLimit.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.energyTransferLimit.set(newValue)).build());
                energy.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Cable transfer limit"), ((Integer)Config.SERVER.cableLimit.get()).intValue()).setTooltip(new Component[]{Component.m_237113_((String)"Maximum amount of energy that can be transfered to/from Warium blocks per tick")}).setDefaultValue((Object)((Integer)Config.SERVER.cableLimit.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.cableLimit.set(newValue)).build());
                energy.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Energy Battery capacity (fe)"), ((Integer)Config.SERVER.batteryCapacity.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.batteryCapacity.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.batteryCapacity.set(newValue)).build());
                energy.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Electric Firebox capacity (fe)"), ((Integer)Config.SERVER.electricFireboxCapacity.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.electricFireboxCapacity.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.electricFireboxCapacity.set(newValue)).build());
                energy.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Electric Firebox consumption (fe/t)"), ((Integer)Config.SERVER.electricFireboxConsumption.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.electricFireboxConsumption.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.electricFireboxConsumption.set(newValue)).build());
                energy.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Power Reactor capacity (fe)"), ((Integer)Config.SERVER.reactorCapacity.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.reactorCapacity.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.reactorCapacity.set(newValue)).build());
                energy.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Power Reactor generation (fe/t)"), ((Integer)Config.SERVER.reactorGeneration.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.reactorGeneration.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.reactorGeneration.set(newValue)).build());
                energy.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Solar Generator generation (fe/t)"), ((Integer)Config.SERVER.solarGeneration.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.solarGeneration.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.solarGeneration.set(newValue)).build());
                category.addEntry((AbstractConfigListEntry)energy.build());
                break;
            }
            case "Valkyrien Warium": {
                category.addEntry((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Minimal throttle value"), ((Integer)Config.SERVER.minThrottle.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.minThrottle.getDefault()))).setMax(-1).setSaveConsumer(newValue -> Config.SERVER.minThrottle.set(newValue)).build());
                category.addEntry((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Maximum throttle value"), ((Integer)Config.SERVER.maxThrottle.get()).intValue()).setDefaultValue((Object)((Integer)Config.SERVER.maxThrottle.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.maxThrottle.set(newValue)).build());
                break;
            }
            case "Create": {
                SubCategoryBuilder heat = entryBuilder.startSubCategory((Component)Component.m_237113_((String)"Heat Level"));
                heat.add((AbstractConfigListEntry)entryBuilder.startSelector((Component)Component.m_237113_((String)"Firebox Heat Level"), (Object[])new String[]{"KINDLED", "SEETHING"}, (Object)((String)Config.SERVER.fireboxHeat.get())).setDefaultValue((Object)((String)Config.SERVER.fireboxHeat.getDefault())).setSaveConsumer(newValue -> Config.SERVER.fireboxHeat.set(newValue)).build());
                heat.add((AbstractConfigListEntry)entryBuilder.startSelector((Component)Component.m_237113_((String)"Kerosene Firebox Heat Level"), (Object[])new String[]{"KINDLED", "SEETHING"}, (Object)((String)Config.SERVER.oilFireboxHeat.get())).setDefaultValue((Object)((String)Config.SERVER.oilFireboxHeat.getDefault())).setSaveConsumer(newValue -> Config.SERVER.oilFireboxHeat.set(newValue)).build());
                heat.add((AbstractConfigListEntry)entryBuilder.startSelector((Component)Component.m_237113_((String)"Electric Firebox Heat Level"), (Object[])new String[]{"KINDLED", "SEETHING"}, (Object)((String)Config.SERVER.electricFireboxHeat.get())).setDefaultValue((Object)((String)Config.SERVER.electricFireboxHeat.getDefault())).setSaveConsumer(newValue -> Config.SERVER.electricFireboxHeat.set(newValue)).build());
                category.addEntry((AbstractConfigListEntry)heat.build());
                SubCategoryBuilder ratios = entryBuilder.startSubCategory((Component)Component.m_237113_((String)"Ratios"));
                ratios.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Kinetic Power to su ratio"), ((Integer)Config.SERVER.kineticToStressRatio.get()).intValue()).setTooltip(new Component[]{Component.m_237113_((String)"How many Stress Untis will be equivalent to 1 Kinetic Power unit")}).setDefaultValue((Object)((Integer)Config.SERVER.kineticToStressRatio.getDefault()))).setMin(1).setSaveConsumer(newValue -> Config.SERVER.kineticToStressRatio.set(newValue)).build());
                ratios.add((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Kinetic Power to speed ratio"), ((Integer)Config.SERVER.kineticToSpeedRatio.get()).intValue()).setTooltip(new Component[]{Component.m_237113_((String)"What Rotation Speed is equivalent to 1 Kinetic Power unit")}).setDefaultValue((Object)((Integer)Config.SERVER.kineticToSpeedRatio.getDefault()))).setMin(1).setMax(5).setSaveConsumer(newValue -> Config.SERVER.kineticToSpeedRatio.set(newValue)).build());
                category.addEntry((AbstractConfigListEntry)ratios.build());
                category.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.m_237113_((String)"Kinetic Converter speed control"), ((Boolean)Config.SERVER.converterSpeedControl.get()).booleanValue()).setTooltip(new Component[]{Component.m_237113_((String)"Whether Kinetic Converter value box allows to select generating speed")}).setDefaultValue((Object)((Boolean)Config.SERVER.converterSpeedControl.getDefault()))).setSaveConsumer(newValue -> Config.SERVER.converterSpeedControl.set(newValue)).build());
                category.addEntry((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField((Component)Component.m_237113_((String)"Kinetic Converter response delay"), ((Integer)Config.SERVER.kineticConverterReponse.get()).intValue()).setTooltip(new Component[]{Component.m_237113_((String)"Tick-measured Kinetic Converter response delay when changing throttle"), Component.m_237113_((String)"WARNING: lowering this value may cause shafts to break when changing throttle too fast")}).setDefaultValue((Object)((Integer)Config.SERVER.kineticConverterReponse.getDefault()))).setMin(0).setMax(40).setSaveConsumer(newValue -> Config.SERVER.kineticConverterReponse.set(newValue)).build());
                if (!WariumAdditions.valkyrien_warium) break;
                category.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.m_237113_((String)"Throttle Rotation Direction Reverse"), ((Boolean)Config.SERVER.throttleToRotationDirection.get()).booleanValue()).setTooltip(new Component[]{Component.m_237113_((String)"Whether negative throttle should reverse Create rotation direction"), Component.m_237113_((String)"for Kinetic Converter and TMFG/Diesel Generators engines")}).setDefaultValue((Object)((Boolean)Config.SERVER.throttleToRotationDirection.getDefault()))).setSaveConsumer(newValue -> Config.SERVER.throttleToRotationDirection.set(newValue)).build());
            }
        }
    }
}

