/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.create;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import crazywoddman.warium_additions.config.Config;
import crazywoddman.warium_additions.util.WariumAdditionsUtil;
import java.util.List;
import java.util.Optional;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.mcreator.crustychunks.block.entity.ElectricFireboxBlockEntity;
import net.mcreator.crustychunks.block.entity.EnergyBatteryBlockEntity;
import net.mcreator.crustychunks.block.entity.EnergyNodeBlockEntity;
import net.mcreator.crustychunks.block.entity.GeneratorBlockEntity;
import net.mcreator.crustychunks.block.entity.LargeElectricMotorBlockEntity;
import net.mcreator.crustychunks.block.entity.PowerReactorPortBlockEntity;
import net.mcreator.crustychunks.block.entity.SolarGeneratorBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;

@Restriction(require={@Condition(value="create", versionPredicates={"[0.5.1.j]"})})
@Mixin(value={ElectricFireboxBlockEntity.class, LargeElectricMotorBlockEntity.class, GeneratorBlockEntity.class, EnergyBatteryBlockEntity.class, PowerReactorPortBlockEntity.class, SolarGeneratorBlockEntity.class, EnergyNodeBlockEntity.class}, remap=false)
public abstract class EnergyTooltip
implements IHaveGoggleInformation {
    private final int fireboxConsumption;
    private final int solarGeneration;

    public EnergyTooltip() {
        this.fireboxConsumption = (Integer)Config.SERVER.electricFireboxConsumption.get();
        this.solarGeneration = (Integer)Config.SERVER.solarGeneration.get();
    }

    private static final LangBuilder builder() {
        return Lang.builder((String)"createaddition");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockEntity blockEntity = (BlockEntity)this;
        Optional resolve = blockEntity.getCapability(ForgeCapabilities.ENERGY).resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)resolve.get();
        String type = ForgeRegistries.BLOCKS.getKey((Object)blockEntity.m_58900_().m_60734_()).m_135815_();
        EnergyTooltip.builder().add(Lang.builder((String)"block").translate("crusty_chunks." + type, new Object[0])).text(":").style(ChatFormatting.AQUA).forGoggles(tooltip);
        if (List.of("energy_battery", "electric_firebox", "power_reactor_port").contains(type)) {
            EnergyTooltip.builder().translate("tooltip.energy.stored", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            EnergyTooltip.builder().text(WariumAdditionsUtil.formatFE(energyStorage.getEnergyStored())).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
            EnergyTooltip.builder().translate("tooltip.energy.capacity", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            EnergyTooltip.builder().text(WariumAdditionsUtil.formatFE(energyStorage.getMaxEnergyStored())).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        }
        if (!List.of("energy_battery", "power_reactor_port").contains(type)) {
            Level level = blockEntity.m_58904_();
            BlockPos pos = blockEntity.m_58899_();
            LangBuilder langBuilder = EnergyTooltip.builder();
            langBuilder.translate(switch (type) {
                case "energy_node" -> "tooltip.energy.usage";
                case "electric_firebox" -> "tooltip.energy.consumption";
                case "large_electric_motor" -> "tooltip.energy.consumption";
                default -> "tooltip.energy.production";
            }, new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            LangBuilder langBuilder2 = EnergyTooltip.builder();
            langBuilder2.text(WariumAdditionsUtil.formatFE(switch (type) {
                case "electric_firebox" -> {
                    if (level.m_276867_(pos) && energyStorage.getEnergyStored() > 0) {
                        yield 0;
                    }
                    yield this.fireboxConsumption;
                }
                case "solar_generator" -> {
                    if (level.m_46461_() && level.m_46861_(pos)) {
                        yield this.solarGeneration;
                    }
                    yield 0;
                }
                default -> energyStorage.getEnergyStored();
            }) + "/t").style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        }
        return true;
    }
}

