/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.createdieselgenerators;

import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.entity.DieselGeneratorBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.LargeDieselGeneratorBlockEntity;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import crazywoddman.warium_additions.config.Config;
import crazywoddman.warium_additions.util.ThrottleProvider;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Restriction(require={@Condition(value="createdieselgenerators", versionPredicates={"[1.2i]"}), @Condition(value="valkyrien_warium")})
@Mixin(value={DieselGeneratorBlockEntity.class, LargeDieselGeneratorBlockEntity.class, HugeDieselEngineBlockEntity.class}, remap=false)
public class GeneratorsThrottleControl {
    @Unique
    private boolean lastSignal;
    @Unique
    private Integer throttle;
    private final boolean throttleToRotationDirection;

    public GeneratorsThrottleControl() {
        this.throttleToRotationDirection = (Boolean)Config.SERVER.throttleToRotationDirection.get();
    }

    @Inject(method={"getGeneratedSpeed"}, at={@At(value="RETURN")}, cancellable=true, require=0)
    private void injectReturn(CallbackInfoReturnable<Float> cir) {
        float originalValue = ((Float)cir.getReturnValue()).floatValue();
        if (originalValue != 0.0f && this.throttleToRotationDirection && this.throttle != null && this.throttle < 0) {
            cir.setReturnValue((Object)Float.valueOf(-1.0f * originalValue));
        }
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lcom/jesz/createdieselgenerators/blocks/entity/HugeDieselEngineBlockEntity;movementDirection:Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", opcode=180), require=0)
    private ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> redirectMovementDirection(final HugeDieselEngineBlockEntity instance) {
        return new ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection>(WindmillBearingBlockEntity.RotationDirection.class, null, (SmartBlockEntity)instance, null){

            public WindmillBearingBlockEntity.RotationDirection get() {
                WindmillBearingBlockEntity.RotationDirection originalDirection = (WindmillBearingBlockEntity.RotationDirection)instance.movementDirection.get();
                if (GeneratorsThrottleControl.this.throttleToRotationDirection && GeneratorsThrottleControl.this.throttle != null && GeneratorsThrottleControl.this.throttle < 0) {
                    return originalDirection == WindmillBearingBlockEntity.RotationDirection.CLOCKWISE ? WindmillBearingBlockEntity.RotationDirection.COUNTER_CLOCKWISE : WindmillBearingBlockEntity.RotationDirection.CLOCKWISE;
                }
                return originalDirection;
            }
        };
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void throttleControl(CallbackInfo callbackInfo) {
        BlockEntity blockEntity = (BlockEntity)this;
        if (blockEntity.m_58904_().m_46467_() % 10L == 0L) {
            this.lastSignal = blockEntity.m_58904_().m_276867_(blockEntity.m_58899_());
            boolean oldPowered = (Boolean)blockEntity.m_58900_().m_61143_((Property)DieselGeneratorBlock.POWERED);
            boolean powered = this.lastSignal;
            if (!this.lastSignal) {
                this.throttle = ThrottleProvider.get(blockEntity, null);
                if (this.throttle != null) {
                    boolean bl = powered = this.throttle == 0;
                }
            }
            if (oldPowered != powered) {
                blockEntity.m_58904_().m_7731_(blockEntity.m_58899_(), (BlockState)blockEntity.m_58900_().m_61124_((Property)DieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 2);
                if (blockEntity instanceof GeneratingKineticBlockEntity) {
                    GeneratingKineticBlockEntity genBlockEntity = (GeneratingKineticBlockEntity)blockEntity;
                    genBlockEntity.updateGeneratedRotation();
                }
            }
        }
    }
}

