/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.crusty_chunks.energy;

import crazywoddman.warium_additions.config.Config;
import net.mcreator.crustychunks.block.entity.ElectricFireboxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ElectricFireboxBlockEntity.class})
public class ElectricFireboxBlockEntityMixin {
    @Unique
    private EnergyStorage energyStorage;
    private final int capacity;
    private final int consumption;
    private final int transLimit;

    public ElectricFireboxBlockEntityMixin() {
        this.capacity = (Integer)Config.SERVER.electricFireboxCapacity.get();
        this.consumption = (Integer)Config.SERVER.electricFireboxConsumption.get() * 40;
        this.transLimit = (Integer)Config.SERVER.energyTransferLimit.get();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void injectEnergyStorage(final BlockPos pos, final BlockState state, CallbackInfo ci) {
        final BlockEntity blockEntity = (BlockEntity)this;
        this.energyStorage = new EnergyStorage(this.capacity, this.transLimit, 0){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int received = super.receiveEnergy(maxReceive, simulate);
                if (!simulate && received > 0) {
                    blockEntity.m_6596_();
                    blockEntity.m_58904_().m_7260_(pos, state, state, 3);
                }
                return received;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                if (simulate || maxExtract != -1 || this.energy < ElectricFireboxBlockEntityMixin.this.consumption) {
                    return 0;
                }
                this.energy -= ElectricFireboxBlockEntityMixin.this.consumption;
                return ElectricFireboxBlockEntityMixin.this.consumption;
            }
        };
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void injectRead(CompoundTag compound, CallbackInfo ci) {
        this.energyStorage.deserializeNBT(compound.m_128423_("energyStorage"));
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void injectSave(CompoundTag compound, CallbackInfo ci) {
        compound.m_128365_("energyStorage", this.energyStorage.serializeNBT());
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectEnergyCapability(Capability<?> capability, Direction facing, CallbackInfoReturnable<LazyOptional<?>> cir) {
        if (capability == ForgeCapabilities.ENERGY) {
            cir.setReturnValue((Object)LazyOptional.of(() -> this.energyStorage).cast());
        }
    }
}

