/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.crusty_chunks.energy;

import crazywoddman.warium_additions.config.Config;
import java.util.ArrayList;
import java.util.Iterator;
import net.mcreator.crustychunks.block.entity.EnergyDistributionNodeBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnergyDistributionNodeBlockEntity.class})
public class EnergyDistributionNodeBlockEntityMixin {
    private final int transLimit;

    public EnergyDistributionNodeBlockEntityMixin() {
        this.transLimit = (Integer)Config.SERVER.energyTransferLimit.get();
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectEnergyCapability(Capability<?> capability, final Direction capFacing, CallbackInfoReturnable<LazyOptional<?>> cir) {
        if (capability == ForgeCapabilities.ENERGY && capFacing != null) {
            final BlockEntity blockEntity = (BlockEntity)this;
            cir.setReturnValue((Object)LazyOptional.of(() -> new EnergyStorage(this.transLimit, this.transLimit, this.transLimit, this.transLimit){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    ArrayList<IEnergyStorage> validStorages = new ArrayList<IEnergyStorage>(6);
                    ArrayList<Integer> receiveAmount = new ArrayList<Integer>(6);
                    for (Direction direction : Direction.values()) {
                        int received;
                        IEnergyStorage cap;
                        BlockEntity sideBlock;
                        if (direction == capFacing || (sideBlock = blockEntity.m_58904_().m_7702_(blockEntity.m_58899_().m_121945_(direction))) == null || (cap = (IEnergyStorage)sideBlock.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse(null)) == null || !cap.canReceive() || (received = cap.receiveEnergy(Math.min(this.capacity, maxReceive), true)) <= 0) continue;
                        validStorages.add(cap);
                        receiveAmount.add(received);
                    }
                    if (!validStorages.isEmpty()) {
                        int totalReceive = 0;
                        Iterator iterator = receiveAmount.iterator();
                        while (iterator.hasNext()) {
                            int amount = (Integer)iterator.next();
                            totalReceive = Math.min(Math.min(this.maxReceive, maxReceive), totalReceive + amount);
                        }
                        int receiveLeft = totalReceive;
                        int sides = validStorages.size();
                        for (int i = 0; i < sides; ++i) {
                            receiveLeft -= ((IEnergyStorage)validStorages.get(i)).receiveEnergy(Math.round(receiveLeft / (sides - i)), simulate);
                        }
                        return totalReceive - receiveLeft;
                    }
                    return 0;
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    for (Direction direction : Direction.values()) {
                        IEnergyStorage cap;
                        BlockEntity sideBlock;
                        if (direction == capFacing || (sideBlock = blockEntity.m_58904_().m_7702_(blockEntity.m_58899_().m_121945_(direction))) == null || (cap = (IEnergyStorage)sideBlock.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse(null)) == null || !cap.canExtract() || cap.getEnergyStored() <= 0) continue;
                        return cap.extractEnergy(Math.min(this.maxExtract, maxExtract), simulate);
                    }
                    return 0;
                }
            }).cast());
        }
    }
}

