/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.mixins.crusty_chunks.energy;

import crazywoddman.warium_additions.config.Config;
import net.mcreator.crustychunks.block.EnergyNodeBlock;
import net.mcreator.crustychunks.block.entity.EnergyNodeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnergyNodeBlockEntity.class})
public class EnergyNodeBlockEntityMixin {
    private final int limit;
    private int lastTransfer;
    private int count;
    private final EnergyStorage energyStats;

    public EnergyNodeBlockEntityMixin() {
        this.limit = (Integer)Config.SERVER.cableLimit.get();
        this.energyStats = new EnergyStorage(this.limit){

            public int getEnergyStored() {
                if (EnergyNodeBlockEntityMixin.this.count > 6) {
                    this.energy = 0;
                } else {
                    ++EnergyNodeBlockEntityMixin.this.count;
                }
                return this.energy;
            }
        };
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void injectRead(CompoundTag compound, CallbackInfo ci) {
        this.energyStats.deserializeNBT(compound.m_128423_("energyStorage"));
        this.count = 0;
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void injectSave(CompoundTag compound, CallbackInfo ci) {
        compound.m_128405_("energyStorage", this.lastTransfer);
    }

    private EnergyStorage getEnergyStorage(final IEnergyStorage storage) {
        final BlockEntity blockEntity = (BlockEntity)this;
        return new EnergyStorage(this.limit){

            public int getEnergyStored() {
                return storage.getEnergyStored();
            }

            public boolean canExtract() {
                return storage.canExtract();
            }

            public boolean canReceive() {
                return storage.canReceive();
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                if (!this.canReceive()) {
                    return 0;
                }
                int received = storage.receiveEnergy(Math.min(maxReceive, this.capacity), simulate);
                if (!simulate && received > 0) {
                    EnergyNodeBlockEntityMixin.this.lastTransfer = received;
                    blockEntity.m_6596_();
                    BlockState state = blockEntity.m_58900_();
                    blockEntity.m_58904_().m_7260_(blockEntity.m_58899_(), state, state, 2);
                }
                return received;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                if (!this.canExtract()) {
                    return 0;
                }
                int extracted = storage.extractEnergy(Math.min(maxExtract, this.capacity), simulate);
                if (!simulate && extracted > 0) {
                    EnergyNodeBlockEntityMixin.this.lastTransfer = extracted;
                    blockEntity.m_6596_();
                    BlockState state = blockEntity.m_58900_();
                    blockEntity.m_58904_().m_7260_(blockEntity.m_58899_(), state, state, 2);
                }
                return extracted;
            }
        };
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectEnergyCapability(Capability<?> capability, Direction capFacing, CallbackInfoReturnable<LazyOptional<?>> cir) {
        if (capability == ForgeCapabilities.ENERGY) {
            BlockEntity blockEntity = (BlockEntity)this;
            Level level = blockEntity.m_58904_();
            if (level.f_46443_) {
                cir.setReturnValue((Object)LazyOptional.of(() -> this.energyStats).cast());
            } else {
                IEnergyStorage storage;
                BlockEntity connectedNode;
                CompoundTag data;
                Direction nodeFacing = (Direction)blockEntity.m_58900_().m_61143_((Property)EnergyNodeBlock.FACING);
                if (capFacing == null) {
                    IEnergyStorage storage2;
                    BlockEntity connectedBlock = level.m_7702_(blockEntity.m_58899_().m_121945_(nodeFacing.m_122424_()));
                    if (connectedBlock != null && (storage2 = (IEnergyStorage)connectedBlock.getCapability(ForgeCapabilities.ENERGY, nodeFacing).orElse(null)) != null) {
                        cir.setReturnValue((Object)LazyOptional.of(() -> this.getEnergyStorage(storage2)).cast());
                    }
                } else if (capFacing == nodeFacing.m_122424_() && (data = blockEntity.getPersistentData()).m_128441_("PowerX") && (connectedNode = level.m_7702_(new BlockPos(data.m_128451_("PowerX"), data.m_128451_("PowerY"), data.m_128451_("PowerZ")))) != null && connectedNode instanceof EnergyNodeBlockEntity && (storage = (IEnergyStorage)connectedNode.getCapability(ForgeCapabilities.ENERGY).orElse(null)) != null) {
                    cir.setReturnValue((Object)LazyOptional.of(() -> this.getEnergyStorage(storage)).cast());
                }
            }
        }
    }
}

