/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_additions.util;

import crazywoddman.warium_additions.WariumAdditions;
import crazywoddman.warium_additions.compat.curios.CuriosUtil;
import crazywoddman.warium_additions.registry.RegistryItems;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class WariumAdditionsUtil {
    public static ItemStack getWariumStack(String id) {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)id)));
    }

    public static FluidStack getWariumFluid(String id, int amount) {
        return new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)id)), amount);
    }

    public static Ingredient getIngredientTag(String namespace, String id) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id)));
    }

    public static void checkEnergy(LevelAccessor level, Player player, boolean isSelected) {
        BlockEntity blockEntity;
        Vec3 endPosition;
        Vec3 eyePosition;
        BlockHitResult hitResult;
        if (!isSelected && WariumAdditions.curios) {
            isSelected = CuriosUtil.getItem((LivingEntity)player, "belt", (Item)RegistryItems.ENERGY_METER.get()).isPresent();
        }
        if (isSelected && (hitResult = level.m_45547_(new ClipContext(eyePosition = player.m_20299_(1.0f), endPosition = eyePosition.m_82549_(player.m_20252_(1.0f).m_82490_(player.getBlockReach())), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player))).m_6662_() == HitResult.Type.BLOCK && (blockEntity = level.m_7702_(hitResult.m_82425_())) != null) {
            blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(storage -> player.m_5661_((Component)Component.m_237115_((String)"warium_additions.tooltip.energy.power").m_7220_((Component)Component.m_237113_((String)(": " + WariumAdditionsUtil.formatFE(storage.getEnergyStored())))), true));
        }
    }

    public static boolean compareFluids(Fluid first, Fluid second) {
        String secondPath;
        if (first.equals(second)) {
            return true;
        }
        String firstPath = ForgeRegistries.FLUIDS.getKey((Object)first).m_135815_();
        return firstPath.equals(secondPath = ForgeRegistries.FLUIDS.getKey((Object)second).m_135815_()) || ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)firstPath))).contains((Object)second) || ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)secondPath))).contains((Object)first);
    }

    public static String formatSeconds(int totalSeconds) {
        int seconds = totalSeconds % 60;
        if (totalSeconds >= 3600) {
            int hours = totalSeconds / 3600;
            int minutes = totalSeconds % 3600 / 60;
            return String.format("%d:%02d:%02d", hours, minutes, seconds);
        }
        int minutes = totalSeconds / 60;
        return String.format("%d:%02d", minutes, seconds);
    }

    public static String formatFE(int fe) {
        if (fe >= 1000000000) {
            return (double)Math.round(fe / 100000000) / 10.0 + "Gfe";
        }
        if (fe >= 1000000) {
            return (double)Math.round(fe / 100000) / 10.0 + "Mfe";
        }
        if (fe >= 1000) {
            return (double)Math.round(fe / 100) / 10.0 + "Kfe";
        }
        return fe + "fe";
    }
}

