package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBedBlock;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.serialization.MapCodec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_6088;
import net.minecraft.world.level.block.*;
import javax.annotation.Nullable;

public class BlockMaidBed extends class_2383 implements IBedBlock {
    public static final class_2754<class_2742> PART = class_2741.field_12483;
    public static final class_2746 OCCUPIED = class_2741.field_12528;
    protected static final class_265 BASE = class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 9.0, 16.0);

    public BlockMaidBed() {
        super(class_4970.class_2251.method_9637().method_9626(class_2498.field_11547).method_9626(class_2498.field_11547).method_9632(0.2F).method_22488().method_50012(class_3619.field_15971));
        this.method_9590(this.field_10647.method_11664().method_11657(PART, class_2742.field_12557).method_11657(OCCUPIED, false));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return BASE;
    }

    @Override
    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (facing == getNeighbourDirection(stateIn.method_11654(PART), stateIn.method_11654(field_11177))) {
            return facingState.method_27852(this) && facingState.method_11654(PART) != stateIn.method_11654(PART) ? stateIn.method_11657(OCCUPIED, facingState.method_11654(OCCUPIED)) : class_2246.field_10124.method_9564();
        } else {
            return super.method_9559(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
    }

    @Override
    public class_2680 method_9576(class_1937 worldIn, class_2338 pos, class_2680 state, class_1657 player) {
        if (!worldIn.field_9236 && player.method_7337()) {
            class_2742 bedpart = state.method_11654(PART);
            if (bedpart == class_2742.field_12557) {
                class_2338 blockpos = pos.method_10093(getNeighbourDirection(bedpart, state.method_11654(field_11177)));
                class_2680 blockstate = worldIn.method_8320(blockpos);
                if (blockstate.method_26204() == this && blockstate.method_11654(PART) == class_2742.field_12560) {
                    worldIn.method_8652(blockpos, class_2246.field_10124.method_9564(), class_2248.field_31036 | class_2248.field_31032);
                    worldIn.method_8444(player, class_6088.field_31144, blockpos, class_2248.method_9507(blockstate));
                }
            }
        }
        return super.method_9576(worldIn, pos, state, player);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_11177, PART, OCCUPIED);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8042();
        class_2338 relativePos = context.method_8037().method_10093(direction);
        return context.method_8045().method_8320(relativePos).method_26166(context) ? this.method_9564().method_11657(field_11177, direction) : null;
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (!worldIn.field_9236) {
            class_2338 blockpos = pos.method_10093(state.method_11654(field_11177));
            worldIn.method_8652(blockpos, state.method_11657(PART, class_2742.field_12560), class_2248.field_31036);
            worldIn.method_8408(pos, class_2246.field_10124);
            state.method_30101(worldIn, pos, 3);
        }
    }

    @Override
    public void method_9554(class_1937 worldIn, class_2680 blockState, class_2338 pos, class_1297 entityIn, float fallDistance) {
        super.method_9554(worldIn, blockState, pos, entityIn, fallDistance * 0.5f);
    }

    @Override
    public void method_9502(class_1922 worldIn, class_1297 entity) {
        if (entity.method_21750()) {
            super.method_9502(worldIn, entity);
        } else {
            class_243 movement = entity.method_18798();
            if (movement.field_1351 < 0) {
                double modulus = entity instanceof class_1309 ? 1.0D : 0.8D;
                entity.method_18800(movement.field_1352, -movement.field_1351 * (double) 0.66F * modulus, movement.field_1350);
            }
        }
    }

/*    @Override
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }*/

    @Environment(EnvType.CLIENT)
    @Override
    public long method_9535(class_2680 state, class_2338 pos) {
        class_2338 blockpos = pos.method_10079(state.method_11654(field_11177), state.method_11654(PART) == class_2742.field_12560 ? 0 : 1);
        return class_3532.method_15371(blockpos.method_10263(), pos.method_10264(), blockpos.method_10260());
    }

    @Override
    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    @Override
    public boolean isBed(class_2680 state, class_1922 world, class_2338 pos, @Nullable class_1309 entity) {
        if (entity instanceof EntityMaid) {
            return true;
        }
        assert entity != null;
        return IBedBlock.super.isBed(state, world, pos, entity);
    }

    private class_2350 getNeighbourDirection(class_2742 part, class_2350 direction) {
        return part == class_2742.field_12557 ? direction : direction.method_10153();
    }

    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return method_54094((properties) -> new BlockMaidBed());
    }
}
