package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.CacheIconTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.IconCache;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1011;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.apache.commons.lang3.time.StopWatch;

import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;


@Environment(EnvType.CLIENT)
public class CacheScreen<T extends class_1309, E extends IModelInfo> extends class_437 {
    protected final class_437 parent;
    protected final class_1299<T> entityType;
    protected final Queue<E> modelInfos;
    protected final EntityRender<T, E> entityRender;
    protected final int totalCount;
    protected final StopWatch stopWatch;

    public CacheScreen(class_437 parent, class_1299<T> entityType, Queue<E> modelInfos, EntityRender<T, E> entityRender) {
        super(class_2561.method_43470("Cache Screen"));
        this.parent = parent;
        this.entityType = entityType;
        this.modelInfos = modelInfos;
        this.entityRender = entityRender;
        this.totalCount = modelInfos.size();
        this.stopWatch = StopWatch.createStarted();
    }

    @SuppressWarnings("unchecked")
    private void drawEntity(class_332 graphics, int posX, int posY, E modelInfo, int scaleModified) {
        class_1937 world = Screens.getClient(this).field_1687;
        if (world == null) {
            return;
        }
        T entity;
        try {
            entity = (T) EntityCacheUtil.ENTITY_CACHE.get(entityType, () -> entityType.method_5883(world));
        } catch (ExecutionException | ClassCastException e) {
            e.fillInStackTrace();
            return;
        }
        entityRender.render(graphics, posX, posY, modelInfo, scaleModified, entity);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);

        if (modelInfos.isEmpty()) {
            stopWatch.stop();
            double timeCost = stopWatch.getTime(TimeUnit.MILLISECONDS) / 1000.0;
            TouhouLittleMaid.LOGGER.info("Cache icon time: {} seconds", timeCost);
            class_310.method_1551().method_1507(parent);
            return;
        }

        // 每帧尝试缓存 5 个
        graphics.method_51448().method_22903();
        for (int i = 0; i < 5; i++) {
            if (modelInfos.isEmpty()) {
                return;
            }
            graphics.method_51448().method_46416(0, 0, 200);
            doCacheIcon(graphics);
        }
        graphics.method_51448().method_22909();

        int finishSize = totalCount - modelInfos.size();
        graphics.method_27534(field_22793, class_2561.method_43469("gui.touhou_little_maid.cache_screen.progress", finishSize, totalCount), this.field_22789 / 2, this.field_22790 - 42, 0xFFFFFF);
        graphics.method_27534(field_22793, class_2561.method_43471("gui.touhou_little_maid.cache_screen.desc"), this.field_22789 / 2, this.field_22790 - 30, 0xFFFFFF);
    }

    protected void doCacheIcon(class_332 graphics) {
        E modelInfo = modelInfos.poll();
        if (modelInfo != null) {
            double guiScale = class_310.method_1551().method_22683().method_4495();
            int scaleModified = (int) Math.ceil((256 / guiScale));

            graphics.method_25294(0, 0, scaleModified, scaleModified + 2, IconCache.BACKGROUND_COLOR);
            this.drawEntity(graphics, 0, 0, modelInfo, scaleModified);
            class_1011 nativeImage = IconCache.exportImageFromScreenshot(256, IconCache.BACKGROUND_COLOR_SHIFTED);

            class_2960 modelId = modelInfo.getModelId();
            CacheIconTexture cacheIconTexture = new CacheIconTexture(modelId, nativeImage);
            class_310.method_1551().method_1531().method_4616(modelInfo.getCacheIconId(), cacheIconTexture);
        }
    }

    public interface EntityRender<T extends class_1309, E extends IModelInfo> {
        void render(class_332 graphics, int posX, int posY, E modelInfo, int scaleModified, T entity);
    }
}
