package com.github.tartaricacid.touhoulittlemaid.compat.rei.altar;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.rei.MaidREIClientPlugin;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import java.util.ArrayList;
import java.util.List;

public class ReiAltarRecipeCategory implements DisplayCategory<ReiAltarRecipeDisplay> {
    private static final class_5250 TITLE = class_2561.method_43471("jei.touhou_little_maid.altar_craft.title");
    private static final class_2960 ALTAR_ICON = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/altar_icon.png");
    private static final class_2960 POWER_ICON = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/entity/power_point.png");
    private final Renderer icon;

    public ReiAltarRecipeCategory() {
        this.icon = (graphics, bounds, mouseX, mouseY, delta) -> graphics.method_25290(ALTAR_ICON, bounds.x, bounds.y, 0, 0, 16, 16, 16, 16);
    }

    @Override
    public CategoryIdentifier<? extends ReiAltarRecipeDisplay> getCategoryIdentifier() {
        return MaidREIClientPlugin.ALTAR;
    }

    @Override
    public class_2561 getTitle() {
        return TITLE;
    }

    @Override
    public Renderer getIcon() {
        return icon;
    }

    @Override
    public int getDisplayHeight() {
        return 125;
    }

    @Override
    public int getDisplayWidth(ReiAltarRecipeDisplay display) {
        return 160;
    }

    @Override
    public List<Widget> setupDisplay(ReiAltarRecipeDisplay display, Rectangle bounds) {
        int darkGray = 0x555555;
        class_327 font = class_310.method_1551().field_1772;
        String result = class_1074.method_4662("jei.touhou_little_maid.altar_craft.result", class_1074.method_4662(display.getLangKey()));
        int startX = bounds.x;
        int startY = bounds.y + 5;

        List<Widget> widgets = new ArrayList<>();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createSlot(new Point(startX + 40, startY + 35)).entries(getInput(display.getInputEntries(), 0)).markInput());
        widgets.add(Widgets.createSlot(new Point(startX + 40, startY + 55)).entries(getInput(display.getInputEntries(), 1)).markInput());
        widgets.add(Widgets.createSlot(new Point(startX + 60, startY + 15)).entries(getInput(display.getInputEntries(), 2)).markInput());
        widgets.add(Widgets.createSlot(new Point(startX + 80, startY + 15)).entries(getInput(display.getInputEntries(), 3)).markInput());
        widgets.add(Widgets.createSlot(new Point(startX + 100, startY + 35)).entries(getInput(display.getInputEntries(), 4)).markInput());
        widgets.add(Widgets.createSlot(new Point(startX + 100, startY + 55)).entries(getInput(display.getInputEntries(), 5)).markInput());
        widgets.add(Widgets.createSlot(new Point(startX + 140 - 5, startY + 5)).entries(display.getOutputEntries().get(0)).markOutput());

        widgets.add(Widgets.createTexturedWidget(POWER_ICON, startX + 72, startY + 38, 32, 0, 16, 16, 64, 64));
        widgets.add(Widgets.withTranslate(Widgets.createDrawableWidget((guiGraphics, mouseX, mouseY, v) -> {
            guiGraphics.method_51433(font, result, 0, 0, darkGray, false);
        }), startX + (int) ((bounds.getWidth() - font.method_1727(result)) / 2.0f), startY + 85, 0));

        widgets.add(Widgets.withTranslate(Widgets.createDrawableWidget((guiGraphics, mouseX, mouseY, v) -> {
            guiGraphics.method_51433(font, String.format("×%.2f", display.getPowerCost()), 0, 0, darkGray, false);
        }), startX + 65, startY + 55, 0));

        return widgets;
    }

    private EntryIngredient getInput(List<EntryIngredient> inputs, int index) {
        if (index < inputs.size()) {
            return inputs.get(index);
        }
        return EntryIngredient.empty();
    }
}