package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.sensor;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4148;

public class MaidPickupEntitiesSensor extends class_4148<EntityMaid> {
    private static final int VERTICAL_SEARCH_RANGE = 4;

    public MaidPickupEntitiesSensor() {
        super(30);
    }

    @Override
    public Set<class_4140<?>> method_19099() {
        return ImmutableSet.of(InitEntities.VISIBLE_PICKUP_ENTITIES);
    }

    @Override
    protected void doTick(class_3218 worldIn, EntityMaid maid) {
        if (!maid.method_6181()) {
            return;
        }
        float radius = maid.method_18413();
        class_238 aabb;
        if (maid.method_18410()) {
            aabb = new class_238(maid.method_18412()).method_1009(radius, VERTICAL_SEARCH_RANGE, radius);
        } else {
            aabb = maid.method_5829().method_1009(radius, VERTICAL_SEARCH_RANGE, radius);
        }
        List<class_1297> allEntities = worldIn.method_8390(class_1297.class, aabb, class_1297::method_5805);
        allEntities.sort(Comparator.comparingDouble(maid::method_5858));
        List<class_1297> optional = allEntities.stream()
                .filter(e -> maid.canPickup(e, true))
                .filter(e -> e.method_24516(maid, radius + 1))
                .filter(e -> maid.method_18407(e.method_24515()))
                .filter(maid::method_6057).collect(Collectors.toList());
        maid.method_18868().method_18878(InitEntities.VISIBLE_PICKUP_ENTITIES, optional);
    }
}
