package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public abstract class MaidMoveToBlockTask extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 120;
    private final float movementSpeed;
    private final int verticalSearchRange;
    protected int verticalSearchStart;
    /**
     * 最近工作点标志位（用于记录当前工作的方块位置，缓存下来便于下次在该点附近工作）
     */
    private class_2338 currentWorkPos;

    public MaidMoveToBlockTask(float movementSpeed) {
        this(movementSpeed, 1);
    }

    public MaidMoveToBlockTask(float movementSpeed, int verticalSearchRange) {
        super(ImmutableMap.of(class_4140.field_18445, class_4141.field_18457,
                InitEntities.TARGET_POS, class_4141.field_18457));
        this.movementSpeed = movementSpeed;
        this.verticalSearchRange = verticalSearchRange;
        this.setMaxCheckRate(MAX_DELAY_TIME);
    }

    protected final void searchForDestination(class_3218 worldIn, EntityMaid maid) {
        MaidPathFindingBFS pathFinding = getOrCreateArrivalMap(worldIn, maid);
        class_2338 centrePos = this.getWorkSearchPos(maid);
        int searchRange = (int) maid.method_18413();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int y = this.verticalSearchStart; y <= this.verticalSearchRange; y = y > 0 ? -y : 1 - y) {
            for (int i = 0; i < searchRange; ++i) {
                for (int x = 0; x <= i; x = x > 0 ? -x : 1 - x) {
                    for (int z = x < i && x > -i ? i : 0; z <= i; z = z > 0 ? -z : 1 - z) {
                        mutableBlockPos.method_25504(centrePos, x, y - 1, z);
                        if (maid.method_18407(mutableBlockPos) && shouldMoveTo(worldIn, maid, mutableBlockPos) && checkPathReach(maid, pathFinding, mutableBlockPos)
                                && checkOwnerPos(maid, mutableBlockPos)) {
                            class_4215.method_24561(maid, mutableBlockPos, this.movementSpeed, 0);
                            maid.method_18868().method_18878(InitEntities.TARGET_POS, new class_4099(mutableBlockPos));
                            this.currentWorkPos = mutableBlockPos;
                            this.setNextCheckTickCount(5);
                            this.clearCurrentArrivalMap(pathFinding);
                            return;
                        }
                    }
                }
            }
        }
        this.currentWorkPos = null;
        this.clearCurrentArrivalMap(pathFinding);
    }

    protected void clearCurrentArrivalMap(MaidPathFindingBFS pathFinding) {
        pathFinding.finish();
    }

    /**
     * 获取可达性地图的寻路对象
     */
    protected MaidPathFindingBFS getOrCreateArrivalMap(class_3218 worldIn, EntityMaid maid) {
        return new MaidPathFindingBFS(maid.method_5942().method_6342(), worldIn, maid);
    }

    // 获取工作的搜寻中心点
    private class_2338 getWorkSearchPos(EntityMaid maid) {
        if (maid.method_18410()) {
            // 当且仅当开启home模式，并且工作点在工作范围内才返回最近工作点
            if (this.currentWorkPos != null && maid.method_18407(currentWorkPos)) {
                return this.currentWorkPos;
            } else {
                return maid.method_18412();
            }
        } else {
            return maid.method_24515();
        }
    }

    private boolean checkOwnerPos(EntityMaid maid, class_2338 mutableBlockPos) {
        if (maid.isHomeModeEnable()) {
            return true;
        }
        return maid.method_35057() != null && mutableBlockPos.method_19769(maid.method_35057().method_19538(), 8);
    }

    /**
     * 判定条件
     *
     * @param worldIn  当前实体所处的 world
     * @param entityIn 当前需要移动的实体
     * @param pos      当前检索的 pos
     * @return 是否符合判定条件
     */
    protected abstract boolean shouldMoveTo(class_3218 worldIn, EntityMaid entityIn, class_2338 pos);

    @Deprecated(forRemoval = true)
    protected boolean checkPathReach(EntityMaid maid, class_2338 pos) {
        return maid.canPathReach(pos);
    }

    protected boolean checkPathReach(EntityMaid maid, MaidPathFindingBFS pathFinding, class_2338 pos) {
        return pathFinding.canPathReach(pos);
    }
}
