package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent.TANK_BACKPACK_TAG;

public class ItemTankBackpack extends ItemMaidBackpack {
    public static class_1799 getTankBackpack(class_7225.class_7874 provider, TankBackpackData data) {
        class_1799 backpack = InitItems.TANK_BACKPACK.method_7854();
        class_2487 tags = backpack.method_57824(TANK_BACKPACK_TAG);
        if (tags == null) {
            tags = new class_2487();
            backpack.method_57379(InitDataComponent.TANK_BACKPACK_TAG, tags);
        }
        data.getTank().writeNbt(tags, provider);
        return backpack;
    }

    public static void setTankBackpack(EntityMaid maid, TankBackpackData data, class_1799 backpack) {
        class_2487 tags = backpack.method_57824(TANK_BACKPACK_TAG);
        if (tags == null) {
            tags = new class_2487();
            backpack.method_57379(InitDataComponent.TANK_BACKPACK_TAG, tags);
        }
        data.loadTank(tags, maid);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1792.class_9635 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        class_2487 nbt = stack.method_57824(TANK_BACKPACK_TAG);
        if (nbt != null) {
            //CompoundTag compound = nbt.getCompound("Fluid");
            class_2487 compound = nbt.method_10562("variant");
            if (compound.method_33133() || worldIn == null) {
                return;
            }
            class_7225.class_7874 registries = worldIn.method_59527();
            if (registries == null) {
                return;
            }


            class_5250 fluidInfo;
            //Optional<FluidStack> fluid = FluidStack.read(registries, compound);
            Optional<FluidVariant> fluid = FluidVariant.CODEC.parse(registries.method_57093(class_2509.field_11560), compound).result();
            if (fluid.isEmpty()) {
                return;
            }
            FluidVariant fluidStack = fluid.get();
            if (fluidStack.getFluid() == class_3612.field_15906 || nbt.method_10537("amount") == 0) {
                fluidInfo = class_2561.method_43471("tooltips.touhou_little_maid.tank_backpack.empty_fluid").method_27692(class_124.field_1080);
            } else {
                fluidInfo = class_2561.method_43469("tooltips.touhou_little_maid.tank_backpack.fluid",
                        FluidVariantAttributes.getName(fluidStack),
                        nbt.method_10537("amount") / 81).method_27692(class_124.field_1080);
            }
            tooltip.add(fluidInfo);
        }
    }
}
