package com.github.tartaricacid.touhoulittlemaid.util;

import net.minecraft.class_1011;
import net.minecraft.class_310;
import net.minecraft.class_318;
import org.lwjgl.system.MemoryUtil;

/**
 * Refer: https://github.com/CyclopsMC/IconExporter/
 * MIT license: https://github.com/CyclopsMC/IconExporter/blob/master-1.21/LICENSE.txt
 */
public final class IconCache {
    /**
     * ARGB
     */
    public static final int BACKGROUND_COLOR = 0xFF_00_FF_00;
    /**
     * 不知何故，Minecraft 的顺序是 ABGR
     */
    public static final int BACKGROUND_COLOR_SHIFTED = 0xFF_00_FF_00;

    public static class_1011 exportImageFromScreenshot(int scaleImage, int backgroundColor) {
        // 尝试全屏截图
        class_1011 imageFull = class_318.method_1663(class_310.method_1551().method_1522());
        // 从全屏截图中获取我们需要的那部分
        class_1011 image = getSubImage(imageFull, scaleImage, scaleImage);
        // 关闭全屏截图的缓存
        imageFull.close();

        // 将背景颜色转换为透明像素
        for (int cx = 0; cx < image.method_4307(); cx++) {
            for (int cy = 0; cy < image.method_4323(); cy++) {
                int color = image.method_4315(cx, cy);
                // 如果颜色等于背景色，那么直接设置为透明像素
                if (color == backgroundColor) {
                    image.method_4305(cx, cy, 0x00_00_00_00);
                }
            }
        }

        return image;
    }

    private static class_1011 getSubImage(class_1011 image, int width, int height) {
        class_1011 imageSub = new class_1011(width, height, false);
        // 只截取其中一部分贴图
        for (int y = 0; y < imageSub.method_4323(); y++) {
            int pointerOffset = y * image.method_4307() * image.method_4318().method_4335();
            int pointerOffsetSub = y * imageSub.method_4307() * imageSub.method_4318().method_4335();
            MemoryUtil.memCopy(image.field_4988 + (long) pointerOffset, imageSub.field_4988 + (long) pointerOffsetSub, (long) imageSub.method_4307() * image.method_4318().method_4335());
        }
        return imageSub;
    }
}
