/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.animation.ICustomAnimation;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.special.SwimAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.special.TridentAnimation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_4587;

public final class HardcodedAnimationManger {
    private static final List<ICustomAnimation<? extends class_1309>> ANIMATIONS = Lists.newLinkedList();

    public static void init() {
        HardcodedAnimationManger manager = new HardcodedAnimationManger();
        manager.addMaidAnimation(new SwimAnimation());
        manager.addMaidAnimation(new TridentAnimation());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.addHardcodeAnimation(manager);
        }
    }

    public static void playMaidAnimation(IMaid maid, HashMap<String, ModelRendererWrapper> models, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (ICustomAnimation<? extends class_1309> animation : ANIMATIONS) {
            animation.setRotationAngles((class_1309)maid.asEntity(), models, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public static void playGeckoMaidAnimation(IMaid maid, AnimatedGeoModel model, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (ICustomAnimation<? extends class_1309> animation : ANIMATIONS) {
            animation.setGeckoRotationAngles((class_1309)maid.asEntity(), model, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public static void setupRotations(class_1308 entity, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTicks, boolean isGecko) {
        for (ICustomAnimation<? extends class_1309> animation : ANIMATIONS) {
            if (isGecko) {
                animation.setupGeckoRotations((class_1309)entity, poseStack, ageInTicks, rotationYaw, partialTicks);
                continue;
            }
            animation.setupRotations((class_1309)entity, poseStack, ageInTicks, rotationYaw, partialTicks);
        }
    }

    public void addMaidAnimation(ICustomAnimation<class_1308> animation) {
        ANIMATIONS.add(animation);
    }
}

