/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.sound;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.SoundElementButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.SoundPackButton;
import com.github.tartaricacid.touhoulittlemaid.client.sound.CustomSoundLoader;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidSoundInstance;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.SoundData;
import com.github.tartaricacid.touhoulittlemaid.client.sound.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetMaidSoundIdPackage;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.apache.commons.lang3.StringUtils;

public class MaidSoundPackGui
extends class_437 {
    private static final class_2960 ICON = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/gui/maid_custom_sound.png");
    private final int packPerSize = 4;
    private final int soundPerSize = 13;
    private final EntityMaid maid;
    private String selectSoundId = null;
    private int startX;
    private int startY;
    private int packPage = 0;
    private int soundPage = 0;
    private int packMaxPage = 0;
    private int soundMaxPage = 0;

    public MaidSoundPackGui(EntityMaid maid) {
        super((class_2561)class_2561.method_43470((String)"Maid Custom Sound Pack GUI"));
        this.maid = maid;
    }

    protected void method_25426() {
        this.method_37067();
        this.startX = (this.field_22789 - 400) / 2;
        this.startY = (this.field_22790 - 220) / 2;
        this.packMaxPage = (CustomSoundLoader.CACHE.size() - 1) / 4;
        this.soundMaxPage = 0;
        this.addSoundPackButtons();
        this.addPackPageButtons();
        if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId)) {
            this.addSoundElementButtons();
            this.addSoundOtherButtons();
            this.addSoundElementPageButtons();
        }
    }

    private void addPackPageButtons() {
        this.method_37063((class_364)new FlatColorButton(this.startX + 5, this.startY + 201, 32, 16, (class_2561)class_2561.method_43470((String)"<"), b -> {
            if (this.packPage > 0) {
                --this.packPage;
                this.method_25426();
            }
        }));
        this.method_37063((class_364)new FlatColorButton(this.startX + 203, this.startY + 201, 32, 16, (class_2561)class_2561.method_43470((String)">"), b -> {
            if ((this.packPage + 1) * 4 < CustomSoundLoader.CACHE.size()) {
                ++this.packPage;
                this.method_25426();
            }
        }));
    }

    private void addSoundElementButtons() {
        int yOffset = 41;
        boolean otherColor = false;
        Map<class_2960, List<SoundData>> buffers = CustomSoundLoader.getSoundCache(this.selectSoundId).buffers();
        List<class_2960> soundIds = List.copyOf(buffers.keySet());
        this.soundMaxPage = (buffers.size() - 1) / 13;
        int startSoundIndex = this.soundPage * 13;
        if (startSoundIndex >= soundIds.size()) {
            this.soundPage = 0;
            startSoundIndex = 0;
        }
        int endSoundIndex = Math.min(soundIds.size(), startSoundIndex + 13);
        for (int i = startSoundIndex; i < endSoundIndex; ++i) {
            class_2960 soundEvent = soundIds.get(i);
            this.method_37063((class_364)new SoundElementButton(this.startX + 245, this.startY + yOffset, 152, 12, soundEvent, buffers.get(soundEvent), otherColor, b -> {
                SoundElementButton soundButton = (SoundElementButton)b;
                class_3414 event = (class_3414)class_7923.field_41172.method_10223(soundButton.getSoundEvent());
                if (this.field_22787 != null && event != null) {
                    this.field_22787.method_1483().method_4873((class_1113)new MaidSoundInstance(event, this.selectSoundId, this.maid, true));
                }
            }).setTooltips("tooltips.touhou_little_maid.custom_sound.play_sound"));
            otherColor = !otherColor;
            yOffset += 12;
        }
    }

    private void addSoundOtherButtons() {
        this.method_37063((class_364)new FlatColorButton(this.startX + 245, this.startY + 19, 110, 18, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.custom_sound.pack.apply"), b -> {
            if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId)) {
                this.maid.setSoundPackId(this.selectSoundId);
                ClientPlayNetworking.send((class_8710)new SetMaidSoundIdPackage(this.maid.method_5628(), this.selectSoundId));
                this.method_25426();
            }
        }));
        this.method_37063((class_364)new FlatColorButton(this.startX + 358, this.startY + 19, 18, 18, (class_2561)class_2561.method_43473(), b -> {
            String url;
            if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId) && StringUtils.isNotBlank((CharSequence)(url = CustomSoundLoader.getSoundCache(this.selectSoundId).info().getUrl())) && this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new class_407(yes -> {
                    if (yes) {
                        class_156.method_668().method_670(url);
                    }
                    this.field_22787.method_1507((class_437)this);
                }, url, false));
            }
        }).setTooltips("tooltips.touhou_little_maid.custom_sound.open_url"));
        this.method_37063((class_364)new FlatColorButton(this.startX + 379, this.startY + 19, 18, 18, (class_2561)class_2561.method_43473(), b -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1483().method_4873((class_1113)new MaidSoundInstance(InitSounds.MAID_CREDIT, this.selectSoundId, this.maid, true));
            }
        }).setTooltips("tooltips.touhou_little_maid.custom_sound.credit"));
    }

    private void addSoundElementPageButtons() {
        this.method_37063((class_364)new FlatColorButton(this.startX + 245, this.startY + 201, 16, 16, (class_2561)class_2561.method_43470((String)"<"), b -> {
            if (this.soundPage > 0) {
                --this.soundPage;
                this.method_25426();
            }
        }));
        this.method_37063((class_364)new FlatColorButton(this.startX + 381, this.startY + 201, 16, 16, (class_2561)class_2561.method_43470((String)">"), b -> {
            Map<class_2960, List<SoundData>> buffersIn;
            if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId) && (this.soundPage + 1) * 13 < (buffersIn = CustomSoundLoader.getSoundCache(this.selectSoundId).buffers()).size()) {
                ++this.soundPage;
                this.method_25426();
            }
        }));
    }

    private void addSoundPackButtons() {
        int yOffset = 19;
        int startPackIndex = this.packPage * 4;
        ArrayList<String> soundPackIds = new ArrayList<String>(CustomSoundLoader.CACHE.keySet());
        if (startPackIndex >= soundPackIds.size()) {
            this.packPage = 0;
            startPackIndex = 0;
        }
        int endPackIndex = Math.min(soundPackIds.size(), startPackIndex + 4);
        for (int i = startPackIndex; i < endPackIndex; ++i) {
            String soundId = (String)soundPackIds.get(i);
            SoundPackInfo info = CustomSoundLoader.getSoundCache(soundId).info();
            SoundPackButton button = new SoundPackButton(this.startX + 5, this.startY + yOffset, info, b -> {
                this.selectSoundId = soundId;
                this.soundPage = 0;
                this.method_25426();
            });
            if (StringUtils.isNotBlank((CharSequence)info.getDescription())) {
                class_5250 description = ParseI18n.parse(info.getDescription());
                button.setTooltips(Collections.singletonList(description));
            }
            if (soundId.equals(this.selectSoundId)) {
                button.setSelect(true);
            }
            if (soundId.equals(this.maid.getSoundPackId())) {
                button.setUse(true);
            }
            this.method_37063((class_364)button);
            yOffset += 45;
        }
    }

    public void method_25394(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.method_25420(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.method_25294(this.startX, this.startY, this.startX + 240, this.startY + 220, -14013910);
        graphics.method_25294(this.startX + 242, this.startY, this.startX + 400, this.startY + 220, -14013910);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.custom_sound.pack.title"), this.startX + 120, this.startY + 6, 0xFFFFFF);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.custom_sound.sounds.preview"), this.startX + 321, this.startY + 6, 0xFFFFFF);
        graphics.method_25300(this.field_22793, String.format("%d/%d", this.packPage + 1, this.packMaxPage + 1), this.startX + 120, this.startY + 206, 0xBBBBBB);
        for (class_4068 renderable : ((ScreenAccessor)((Object)this)).tlm$getRenderables()) {
            renderable.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        }
        if (StringUtils.isNotBlank((CharSequence)this.selectSoundId) && CustomSoundLoader.CACHE.containsKey(this.selectSoundId)) {
            graphics.method_25300(this.field_22793, String.format("%d/%d", this.soundPage + 1, this.soundMaxPage + 1), this.startX + 321, this.startY + 206, 0xBBBBBB);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)ICON);
            graphics.method_25290(ICON, this.startX + 359, this.startY + 20, 0.0f, 0.0f, 16, 16, 256, 256);
            graphics.method_25290(ICON, this.startX + 380, this.startY + 20, 16.0f, 0.0f, 16, 16, 256, 256);
        }
        ((ScreenAccessor)((Object)this)).tlm$getRenderables().stream().filter(b -> b instanceof FlatColorButton).forEach(b -> ((FlatColorButton)((Object)b)).renderToolTip(graphics, this, pMouseX, pMouseY));
    }
}

