package cn.sh1rocu.touhoulittlemaid.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import java.util.List;

public class ExplosionEvents {
    public static Event<Start> START = EventFactory.createArrayBacked(Start.class, (callbacks) -> (world, explosion) -> {
        for (Start event : callbacks) {
            if (event.onExplosionStart(world, explosion)) {
                return true;
            }
        }

        return false;
    });
    public static Event<Detonate> DETONATE = EventFactory.createArrayBacked(Detonate.class, (callbacks) -> (world, explosion, entities, diameter) -> {
        for (Detonate event : callbacks) {
            event.onDetonate(world, explosion, entities, diameter);
        }

    });

    public ExplosionEvents() {
    }

    public interface Detonate {
        void onDetonate(class_1937 world, class_1927 explosion, List<class_1297> entities, double diameter);
    }

    public interface Start {
        boolean onExplosionStart(class_1937 world, class_1927 explosion);
    }
}
