package com.github.tartaricacid.touhoulittlemaid.client.tooltip;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemContainerTooltip;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5684;

public class ClientItemContainerTooltip implements class_5684 {
    private final class_2371<class_1799> items = class_2371.method_10211();
    private @Nullable class_5250 emptyTip = null;

    public ClientItemContainerTooltip(ItemContainerTooltip containerTooltip) {
        IItemHandler handler = containerTooltip.handler();
        for (int i = 0; i < handler.getSlots(); i++) {
            class_1799 stack = handler.getStackInSlot(i);
            if (!stack.method_7960()) {
                this.items.add(stack);
            }
        }
        if (items.isEmpty()) {
            this.emptyTip = class_2561.method_43471("tooltips.touhou_little_maid.item_container.empty");
        }
    }

    @Override
    public int method_32661() {
        if (emptyTip != null) {
            return 10;
        }
        return 20;
    }

    @Override
    public int method_32664(class_327 font) {
        if (emptyTip != null) {
            return font.method_27525(emptyTip);
        }
        return items.size() * 20;
    }

    @Override
    public void method_32666(class_327 font, int pX, int pY, @NotNull class_332 guiGraphics) {
        if (emptyTip != null) {
            guiGraphics.method_27535(font, emptyTip, pX, pY, class_124.field_1080.method_532());
        } else {
            int i = 0;
            for (class_1799 stack : this.items) {
                int xOffset = pX + i * 20;
                guiGraphics.method_51445(stack, xOffset, pY);
                guiGraphics.method_51431(font, stack, xOffset, pY);
                i++;
            }
        }
    }
}
