package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.*;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.event.common.*;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.script.ScriptType;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class CommonEventsPostJS {
    public void interactMaid(InteractMaidEvent event) {
        if (MaidEventsJS.INTERACT_MAID.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            class_1792 item = event.getStack().method_7909();
            EventResult result = MaidEventsJS.INTERACT_MAID.post(scriptType, item, new InteractMaidEventJS(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidAfterEat(MaidAfterEatEvent event) {
        if (MaidEventsJS.MAID_AFTER_EAT.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            class_1792 item = event.getFoodAfterEat().method_7909();
            MaidEventsJS.MAID_AFTER_EAT.post(scriptType, item, new MaidAfterEatEventJS(event));
        }
    }

    public void maidAttack(MaidAttackEvent event) {
        if (MaidEventsJS.MAID_ATTACK.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            class_2960 id = event.getSource().method_48793().method_40230().map(class_5321::method_29177).orElse(null);
            EventResult result = MaidEventsJS.MAID_ATTACK.post(scriptType, id, new MaidAttackEventJS(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidDamage(MaidDamageEvent event) {
        if (MaidEventsJS.MAID_DAMAGE.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            class_2960 id = event.getSource().method_48793().method_40230().map(class_5321::method_29177).orElse(null);
            EventResult result = MaidEventsJS.MAID_DAMAGE.post(scriptType, id, new MaidDamageEventJS(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidDeath(MaidDeathEvent event) {
        if (MaidEventsJS.MAID_DEATH.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            class_2960 id = event.getSource().method_48793().method_40230().map(class_5321::method_29177).orElse(null);
            EventResult result = MaidEventsJS.MAID_DEATH.post(scriptType, id, new MaidDeathEventJS(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidEquip(MaidEquipEvent event) {
        if (MaidEventsJS.MAID_EQUIP.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            class_1792 item = event.getStack().method_7909();
            MaidEventsJS.MAID_EQUIP.post(scriptType, item, new MaidEquipEventJS(event));
        }
    }

    public void maidFish(MaidFishedEvent event) {
        if (MaidEventsJS.MAID_FISHED.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            MaidEventsJS.MAID_FISHED.post(scriptType, new MaidFishedEventJS(event));
        }
    }

    public void maidHurt(MaidHurtEvent event) {
        if (MaidEventsJS.MAID_HURT.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            class_2960 id = event.getSource().method_48793().method_40230().map(class_5321::method_29177).orElse(null);
            EventResult result = MaidEventsJS.MAID_HURT.post(scriptType, id, new MaidHurtEventJS(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidPickupItemResultPre(MaidPickupEvent.ItemResultPre event) {
        if (MaidEventsJS.MAID_PICKUP_ITEM_RESULT_PRE.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            EventResult result = MaidEventsJS.MAID_PICKUP_ITEM_RESULT_PRE.post(scriptType, new MaidPickupEventJS.ItemResultPre(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidPickupItemResultPost(MaidPickupEvent.ItemResultPost event) {
        if (MaidEventsJS.MAID_PICKUP_ITEM_RESULT_POST.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            MaidEventsJS.MAID_PICKUP_ITEM_RESULT_POST.post(scriptType, new MaidPickupEventJS.ItemResultPost(event));
        }
    }

    public void maidPickupExperienceResult(MaidPickupEvent.ExperienceResult event) {
        if (MaidEventsJS.MAID_PICKUP_EXPERIENCE_RESULT.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            EventResult result = MaidEventsJS.MAID_PICKUP_EXPERIENCE_RESULT.post(scriptType, new MaidPickupEventJS.ExperienceResult(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidPickupArrowResult(MaidPickupEvent.ArrowResult event) {
        if (MaidEventsJS.MAID_PICKUP_ARROW_RESULT.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            EventResult result = MaidEventsJS.MAID_PICKUP_ARROW_RESULT.post(scriptType, new MaidPickupEventJS.ArrowResult(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidPickupPowerPointResult(MaidPickupEvent.PowerPointResult event) {
        if (MaidEventsJS.MAID_PICKUP_POWER_POINT_RESULT.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            EventResult result = MaidEventsJS.MAID_PICKUP_POWER_POINT_RESULT.post(scriptType, new MaidPickupEventJS.PowerPointResult(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidPlaySound(MaidPlaySoundEvent event) {
        if (MaidEventsJS.MAID_PLAY_SOUND.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            EventResult result = MaidEventsJS.MAID_PLAY_SOUND.post(scriptType, new MaidPlaySoundEventJS(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidTick(MaidTickEvent event) {
        if (MaidEventsJS.MAID_TICK.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            EventResult result = MaidEventsJS.MAID_TICK.post(scriptType, new MaidTickEventJS(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidTaskEnable(MaidTaskEnableEvent event) {
        if (MaidEventsJS.MAID_TASK_ENABLE.hasListeners()) {
            ScriptType scriptType = event.getEntityMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            class_2960 uid = event.getTargetTask().getUid();
            EventResult result = MaidEventsJS.MAID_TASK_ENABLE.post(scriptType, uid, new MaidTaskEnableEventJS(event));
            if (result.interruptFalse()) {
                event.setCanceled(true);
            }
        }
    }

    public void maidTamed(MaidTamedEvent event) {
        if (MaidEventsJS.MAID_TAMED.hasListeners()) {
            ScriptType scriptType = event.getMaid().field_6002.field_9236 ? ScriptType.CLIENT : ScriptType.SERVER;
            MaidEventsJS.MAID_TAMED.post(scriptType, new MaidTamedEventJS(event));
        }
    }
}
