package com.github.tartaricacid.touhoulittlemaid.compat.tacz.event;

import cn.sh1rocu.touhoulittlemaid.api.event.LivingAttackEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidHurtEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.init.ModDamageTypes;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8110;

public class GunHurtMaidEvent {
    /**
     * 不伤害自己
     */
    public void onMaidHurt(MaidHurtEvent event) {
        class_1282 source = event.getSource();
        EntityMaid maid = event.getMaid();
        if (maid.method_6139() == null) {
            return;
        }
        if (isBulletDamage(source)) {
            event.setCanceled(true);
        }
    }

    /**
     * 避免通过事件引入伤害的附属模组打死玩家
     */
    public void onGunHurt(EntityHurtByGunEvent.Pre event) {
        class_1297 hurtEntity = event.getHurtEntity();
        class_1309 attacker = event.getAttacker();

        // 不伤害自己 x2
        if (attacker instanceof EntityMaid maid) {
            // 主人和同 Team 玩家免伤
            if (hurtEntity instanceof class_1657 player && maid.method_5722(player)) {
                event.setCanceled(true);
            }
        }

        // 不伤害他人 x2
        if (attacker instanceof class_1657 player) {
            // 主人和同 Team 玩家免伤
            if (hurtEntity instanceof EntityMaid maid && maid.method_5722(player)) {
                event.setCanceled(true);
            }
        }
    }

    /**
     * 不伤害他人
     */
    public void onPlayerHurt(LivingAttackEvent event) {
        class_1309 entity = event.getEntity();
        class_1282 source = event.getSource();
        if (entity instanceof class_1657 player && isBulletDamage(source)) {
            class_1297 causingEntity = source.method_5529();
            // 主人和同 Team 玩家免伤
            if (causingEntity instanceof EntityMaid maid && maid.method_5722(player)) {
                event.setCanceled(true);
            }
        }
    }

    public void onExplosionDetonateEvent(class_1937 world, class_1927 explosion, List<class_1297> entities, double diameter) {
        if (explosion.method_46406() instanceof EntityKineticBullet) {
            entities.removeIf(e -> e instanceof EntityMaid);
        }
    }

    // 暂时放这
    private static final class_5321<class_8110> BULLET_VOID = class_5321.method_29179(class_7924.field_42534, new class_2960(GunMod.MOD_ID, "bullet_void"));
    private static final class_5321<class_8110> BULLET_VOID_IGNORE_ARMOR = class_5321.method_29179(class_7924.field_42534, new class_2960(GunMod.MOD_ID, "bullet_void_ignore_armor"));

    private boolean isBulletDamage(class_1282 source) {
        if (source.method_49708(ModDamageTypes.BULLET) || source.method_49708(ModDamageTypes.BULLET_IGNORE_ARMOR) || source.method_49708(BULLET_VOID) || source.method_49708(BULLET_VOID_IGNORE_ARMOR)) {
            return true;
        }
        if (source.method_48789(class_8103.field_42249)) {
            class_1297 directEntity = source.method_5526();
            return directEntity instanceof EntityKineticBullet;
        }
        return false;
    }
}
