package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandlerModifiable;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.meal.MaidMealManager;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import java.util.List;

public class MaidHomeMealTask extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 50;
    private @Nullable TileEntityPicnicMat tmpPicnicMat = null;
    private long handFullBubbleKey = -1;
    private long mealEmptyBubbleKey = -1;

    public MaidHomeMealTask() {
        super(ImmutableMap.of());
        this.setMaxCheckRate(MAX_DELAY_TIME);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 serverLevel, EntityMaid maid) {
        if (!super.checkExtraStartConditions(serverLevel, maid)) {
            return false;
        }
        if (!maid.getFavorabilityManager().canAdd(Type.HOME_MEAL.getTypeName())) {
            return false;
        }
        if (maid.method_5854() instanceof EntitySit sit && sit.getJoyType().equals(Type.ON_HOME_MEAL.getTypeName())) {
            class_2338 blockPos = sit.getAssociatedBlockPos();
            if (serverLevel.method_8321(blockPos) instanceof TileEntityPicnicMat picnicMat) {
                this.tmpPicnicMat = picnicMat;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void start(class_3218 serverLevel, EntityMaid maid, long gameTime) {
        if (tmpPicnicMat == null) {
            return;
        }

        List<IMaidMeal> maidMeals = MaidMealManager.getMaidMeals(MaidMealType.HOME_MEAL);

        // 对手部进行处理：如果没有空的手部，那就取副手
        class_1268 eanHand = class_1268.field_5810;
        for (class_1268 hand : class_1268.values()) {
            if (maid.method_5998(hand).method_7960()) {
                eanHand = hand;
                break;
            }
        }

        // 先对把手上的物品放入背包做预处理：如果放入背包后，手上还有剩余，那就不执行后续吃的逻辑并添加气泡提示
        class_1799 itemInHand = maid.method_5998(eanHand);
        IItemHandlerModifiable availableInv = maid.getAvailableBackpackInv();
        class_1799 handItemCopy = itemInHand.method_7972();
        class_1799 leftoverStack = ItemHandlerHelper.insertItemStacked(availableInv, handItemCopy, true);
        if (!leftoverStack.method_7960()) {
            this.handFullBubbleKey = maid.getChatBubbleManager().addTextChatBubbleIfTimeout("chat_bubble.touhou_little_maid.inner.home_meal.two_hand_is_full", handFullBubbleKey);
            return;
        }

        // 先搜索所有的格子，检查一下能否吃，并记录 slot
        ItemStackHandler handler = this.tmpPicnicMat.getHandler();
        IntList candidateFood = new IntArrayList();
        for (int i = 0; i < handler.getSlots(); i++) {
            class_1799 stack = handler.getStackInSlot(i);
            if (stack.method_7960()) {
                continue;
            }
            for (IMaidMeal maidMeal : maidMeals) {
                if (maidMeal.canMaidEat(maid, stack, eanHand)) {
                    candidateFood.add(i);
                }
            }
        }

        // 如果没搜索到，不执行后续吃的逻辑
        int size = candidateFood.size();
        if (size == 0) {
            this.mealEmptyBubbleKey = maid.getChatBubbleManager().addTextChatBubbleIfTimeout("chat_bubble.touhou_little_maid.inner.home_meal.meal_is_empty", this.mealEmptyBubbleKey);
            return;
        }

        // 随机选择格子
        int skipCount = maid.method_6051().method_43048(size);
        class_1268 hand = eanHand;
        candidateFood.intStream().skip(skipCount).findFirst().ifPresent(slotIndex -> {
            class_1799 outputStack = handler.extractItem(slotIndex, 1, false);
            this.tmpPicnicMat.refresh();
            maid.method_6122(hand, outputStack);
            class_1799 refreshItemInHand = maid.method_5998(hand);
            for (IMaidMeal maidMeal : maidMeals) {
                if (maidMeal.canMaidEat(maid, refreshItemInHand, hand)) {
                    maid.memoryHandItemStack(handItemCopy);
                    maidMeal.onMaidEat(maid, refreshItemInHand, hand);
                    if (maid.method_35057() instanceof class_3222 serverPlayer) {
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.MAID_PICNIC_EAT);
                    }
                    return;
                }
            }
        });
    }

    @Override
    protected void stop(class_3218 pLevel, EntityMaid pEntity, long pGameTime) {
        this.tmpPicnicMat = null;
    }
}