package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidAnimationMessage;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1680;
import net.minecraft.class_1802;
import net.minecraft.class_1823;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidSnowballTargetTask extends class_4097<EntityMaid> {
    private static final float CHANCE_STOPPING = 1 / 32F;
    private final int attackCooldown;
    private boolean canThrow = false;
    private int attackTime = -1;
    private int playPickUpAnimationDelayTime = -1;

    public MaidSnowballTargetTask(int attackCooldown) {
        super(ImmutableMap.of(class_4140.field_18446, class_4141.field_18458, class_4140.field_22355, class_4141.field_18456), 1200);
        this.attackCooldown = attackCooldown;
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        Optional<class_1309> memory = owner.method_18868().method_18904(class_4140.field_22355);
        if (memory.isPresent()) {
            class_1309 target = memory.get();
            return owner.method_24520(item -> item.method_7909() instanceof class_1823 || item.method_7960()) && class_4215.method_24565(owner, target) && inMaxDistance(owner);
        }
        return false;
    }

    @Override
    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return chanceStop(entityIn) && entityIn.method_18868().method_18896(class_4140.field_22355) && isCurrentTargetInSameLevel(entityIn) && isCurrentTargetAlive(entityIn) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        if (entityIn.method_6047().method_7960()) {
            entityIn.method_6122(class_1268.field_5808, class_1802.field_8543.method_7854());
            NetworkHandler.sendToTrackingEntity(entityIn, MaidAnimationMessage.ID, MaidAnimationMessage.pickUpSnowball(entityIn));
            return;
        }
        if (!(entityIn.method_6047().method_7909() instanceof class_1823) && entityIn.method_6079().method_7960()) {
            entityIn.method_6122(class_1268.field_5810, class_1802.field_8543.method_7854());
            NetworkHandler.sendToTrackingEntity(entityIn, MaidAnimationMessage.ID, MaidAnimationMessage.pickUpSnowball(entityIn));
        }
    }

    @Override
    protected void tick(class_3218 worldIn, EntityMaid owner, long gameTime) {
        owner.method_18868().method_18904(class_4140.field_22355).ifPresent((target) -> {
            boolean canSee = class_4215.method_24565(owner, target);
            if (canThrow && canSee) {
                canThrow = false;
                if (owner.method_6047().method_7909() instanceof class_1823) {
                    owner.method_6104(class_1268.field_5808);
                } else {
                    owner.method_6104(class_1268.field_5810);
                }
                class_4215.method_19554(owner, target);
                performRangedAttack(owner, target);
                this.attackTime = this.attackCooldown + owner.method_6051().method_43048(this.attackCooldown);
                // 略微早一些播放动画
                this.playPickUpAnimationDelayTime = 25;
            } else if (--this.attackTime <= 0) {
                this.canThrow = true;
            }

            // 拾取雪球的动画需要延迟 30 tick 播放，给丢出动画预留一些时间
            if (this.playPickUpAnimationDelayTime >= 0) {
                this.playPickUpAnimationDelayTime--;
            }
            if (this.playPickUpAnimationDelayTime == 0) {
                NetworkHandler.sendToTrackingEntity(owner, MaidAnimationMessage.ID, MaidAnimationMessage.pickUpSnowball(owner));
            }

            // 如果女仆处于捡雪球动画中，禁止移动
            if (owner.animationId == MaidAnimationMessage.PICK_UP_SNOWBALL) {
                // 捡雪球动画默认 1750 毫秒
                if (System.currentTimeMillis() - owner.animationRecordTime > 1750) {
                    owner.animationId = MaidAnimationMessage.NONE;
                    owner.animationRecordTime = -1L;
                }
                owner.method_5942().method_6340();
            }
        });
    }

    private void performRangedAttack(EntityMaid shooter, class_1309 target) {
        // 发射的是无 shooter 雪球，避免打中其他生物惹来攻击
        class_1680 snowball = new class_1680(shooter.method_37908(), shooter.method_23317(), shooter.method_23318(), shooter.method_23321());
        double x = target.method_23317() - shooter.method_23317();
        double y = target.method_5829().field_1322 + target.method_17682() / 3.0F - snowball.method_19538().field_1351;
        double z = target.method_23321() - shooter.method_23321();
        double pitch = Math.sqrt(x * x + z * z) * 0.15D;
        snowball.method_7485(x, y + pitch, z, 1.6F, 1);
        shooter.method_5783(class_3417.field_14873, 0.5F, 0.4F / (shooter.method_6051().method_43057() * 0.4F + 0.8F));
        shooter.method_37908().method_8649(snowball);
    }

    @Override
    protected void stop(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.canThrow = false;
        clearAttackTarget(entityIn);
    }

    private boolean isCurrentTargetInSameLevel(class_1309 entity) {
        Optional<class_1309> optional = entity.method_18868().method_18904(class_4140.field_22355);
        return optional.isPresent() && optional.get().method_37908() == entity.method_37908();
    }

    private boolean isCurrentTargetAlive(class_1309 entity) {
        Optional<class_1309> optional = entity.method_18868().method_18904(class_4140.field_22355);
        return optional.isPresent() && optional.get().method_5805();
    }

    private boolean inMaxDistance(EntityMaid maid) {
        Optional<class_1309> optional = maid.method_18868().method_18904(class_4140.field_22355);
        return optional.isPresent() && maid.method_18407(optional.get().method_24515());
    }

    private boolean chanceStop(class_1309 entity) {
        return entity.method_6051().method_43057() > CHANCE_STOPPING;
    }

    private void clearAttackTarget(class_1309 entity) {
        entity.method_18868().method_18875(class_4140.field_22355);
    }
}