package com.github.tartaricacid.touhoulittlemaid.entity.backpack.data;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3861;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import javax.annotation.Nullable;

public class FurnaceBackpackData extends class_1277 implements IBackpackData {
    private static final int INPUT_INDEX = 0;
    private static final int FUEL_INDEX = 1;
    private static final int OUTPUT_INDEX = 2;
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private final class_1863.class_7266<class_1263, class_3861> quickCheck;
    private final class_1937 level;
    private final class_3913 dataAccess = new class_3913() {
        @Override
        public int method_17390(int index) {
            return switch (index) {
                case 0 -> FurnaceBackpackData.this.litTime;
                case 1 -> FurnaceBackpackData.this.litDuration;
                case 2 -> FurnaceBackpackData.this.cookingProgress;
                case 3 -> FurnaceBackpackData.this.cookingTotalTime;
                default -> 0;
            };
        }

        @Override
        public void method_17391(int index, int value) {
            switch (index) {
                case 0 -> FurnaceBackpackData.this.litTime = value;
                case 1 -> FurnaceBackpackData.this.litDuration = value;
                case 2 -> FurnaceBackpackData.this.cookingProgress = value;
                case 3 -> FurnaceBackpackData.this.cookingTotalTime = value;
            }
        }

        @Override
        public int method_17389() {
            return 4;
        }
    };

    public FurnaceBackpackData(EntityMaid maid) {
        super(3);
        this.quickCheck = class_1863.method_42302(class_3956.field_17546);
        this.level = maid.field_6002;
    }

    @Override
    public class_3913 getDataAccess() {
        return dataAccess;
    }

    @Override
    public void load(class_2487 tag, EntityMaid maid) {
        this.litTime = tag.method_10550("BurnTime");
        this.cookingProgress = tag.method_10550("CookTime");
        this.cookingTotalTime = tag.method_10550("CookTimeTotal");
        this.litDuration = this.getBurnDuration(this.method_5438(FUEL_INDEX));
        this.method_7659(tag.method_10554("Items", class_2520.field_33260));
    }

    @Override
    public void save(class_2487 tag, EntityMaid maid) {
        tag.method_10569("BurnTime", this.litTime);
        tag.method_10569("CookTime", this.cookingProgress);
        tag.method_10569("CookTimeTotal", this.cookingTotalTime);
        tag.method_10566("Items", this.method_7660());
    }

    @Override
    public void serverTick(EntityMaid maid) {
        class_1937 level = maid.method_37908();
        // 如果是燃烧状态，继续燃烧
        if (this.isLit()) {
            --this.litTime;
        }
        class_1799 fuelItem = this.method_5438(FUEL_INDEX);
        boolean inputNotEmpty = !this.method_5438(INPUT_INDEX).method_7960();
        boolean fuelNotEmpty = !fuelItem.method_7960();
        boolean readyForLit = inputNotEmpty && fuelNotEmpty;
        // 要么正在燃烧，要么具备燃烧条件
        if (this.isLit() || readyForLit) {
            // 从缓存中获取配方
            class_3861 recipe = null;
            if (inputNotEmpty) {
                recipe = this.quickCheck.method_42303(this, level).orElse(null);
            }

            int maxStackSize = this.method_5444();
            // 没有燃烧，但是可以燃！
            if (!this.isLit() && this.canBurn(level.method_30349(), recipe, this, maxStackSize)) {
                this.litTime = this.getBurnDuration(fuelItem);
                this.litDuration = this.litTime;
                // 如果此时点燃了
                if (this.isLit()) {
                    // 如果燃料有残留物，比如熔岩桶燃烧后残留一个桶
                    if (fuelItem.method_7909().method_7858() != null) {
                        this.method_5447(FUEL_INDEX, new class_1799(fuelItem.method_7909().method_7858()));
                    } else if (fuelNotEmpty) {
                        // 普通燃料减一
                        fuelItem.method_7934(1);
                        if (fuelItem.method_7960()) {
                            this.method_5447(FUEL_INDEX, new class_1799(fuelItem.method_7909().method_7858()));
                        }
                    }
                }
            }

            // 点燃了，而且也能燃！
            if (this.isLit() && this.canBurn(level.method_30349(), recipe, this, maxStackSize)) {
                // 各种进度增加
                ++this.cookingProgress;
                // 如果进度满了，重置，并给出产物
                if (this.cookingProgress == this.cookingTotalTime) {
                    this.cookingProgress = 0;
                    this.cookingTotalTime = getTotalCookTime(level);
                    // 如果烧制成功，把经验给女仆
                    if (this.burn(level.method_30349(), recipe, this, maxStackSize)) {
                        int exp = this.createExperience(recipe.method_8171());
                        maid.setExperience(maid.getExperience() + exp);
                    }
                }
            } else {
                // 否则直接重置烧制进度
                this.cookingProgress = 0;
            }
        } else if (this.cookingProgress > 0) {
            // 什么，燃料不足，那就逐 tick 递减烧制进度
            this.cookingProgress = class_3532.method_15340(this.cookingProgress - 2, 0, this.cookingTotalTime);
        }
    }

    @Override
    public void method_5447(int index, class_1799 stack) {
        class_1799 slotItem = this.method_5438(index);
        boolean isSameItem = !stack.method_7960() && class_1799.method_31577(slotItem, stack);
        super.method_5447(index, stack);
        if (index == 0 && !isSameItem) {
            this.cookingTotalTime = getTotalCookTime(this.level);
            this.cookingProgress = 0;
        }
    }

    private int createExperience(float recipeExp) {
        int integer = class_3532.method_15375(recipeExp);
        float decimal = class_3532.method_22450(recipeExp);
        if (decimal != 0 && Math.random() < (double) decimal) {
            ++integer;
        }
        return integer;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    private int getBurnDuration(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        } else {
            //return fuel.getBurnTime(RecipeType.SMELTING);
            Integer burnTime = FuelRegistry.INSTANCE.get(fuel.method_7909());
            return burnTime == null ? 0 : burnTime;
        }
    }

    private boolean canBurn(class_5455 access, @Nullable class_3861 recipe, class_1277 container, int maxStackSize) {
        // 先检查输入物品和配方
        if (!container.method_5438(INPUT_INDEX).method_7960() && recipe != null) {
            // 先检查配方结果
            class_1799 result = recipe.method_8116(this, access);
            // 没结果，不能燃烧
            if (result.method_7960()) {
                return false;
            } else {
                // 检查输出栏
                class_1799 output = container.method_5438(OUTPUT_INDEX);
                if (output.method_7960()) {
                    // 空的，可以放
                    return true;
                } else if (!class_1799.method_7984(output, result)) {
                    // 不同物品，不行
                    return false;
                } else if (output.method_7947() + result.method_7947() <= maxStackSize && output.method_7947() + result.method_7947() <= output.method_7914()) {
                    // Forge fix: make furnace respect stack sizes in furnace recipes
                    return true;
                } else {
                    // Forge fix: make furnace respect stack sizes in furnace recipes
                    return output.method_7947() + result.method_7947() <= result.method_7914();
                }
            }
        } else {
            return false;
        }
    }

    private boolean burn(class_5455 access, @Nullable class_3861 recipe, class_1277 container, int maxStackSize) {
        if (recipe != null && this.canBurn(access, recipe, container, maxStackSize)) {
            class_1799 input = container.method_5438(INPUT_INDEX);
            class_1799 result = recipe.method_8116(this, access);
            class_1799 output = container.method_5438(OUTPUT_INDEX);
            // 如果输出栏为空
            if (output.method_7960()) {
                // 放东西
                container.method_5447(OUTPUT_INDEX, result.method_7972());
            } else if (output.method_31574(result.method_7909())) {
                // 相同物品，增长数量即可
                output.method_7933(result.method_7947());
            }
            // 如果是海绵和桶
            if (input.method_31574(class_2246.field_10562.method_8389()) && !container.method_5438(FUEL_INDEX).method_7960() && container.method_5438(FUEL_INDEX).method_31574(class_1802.field_8550)) {
                container.method_5447(FUEL_INDEX, new class_1799(class_1802.field_8705));
            }
            input.method_7934(1);
            return true;
        } else {
            return false;
        }
    }

    private int getTotalCookTime(class_1937 level) {
        return quickCheck.method_42303(this, level).map(class_1874::method_8167).orElse(200);
    }
}
