package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class ItemTankBackpack extends ItemMaidBackpack {
    public static class_1799 getTankBackpack(TankBackpackData data) {
        class_1799 backpack = InitItems.TANK_BACKPACK.method_7854();
        class_2487 tags = backpack.method_7911("Tanks");
        data.getTank().writeNbt(tags);
        return backpack;
    }

    public static void setTankBackpack(EntityMaid maid, TankBackpackData data, class_1799 backpack) {
        class_2487 tags = backpack.method_7941("Tanks");
        if (tags != null) {
            data.loadTank(tags, maid);
        }
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        class_2487 nbt = stack.method_7941("Tanks");
        if (nbt != null) {
            class_5250 fluidInfo;
            FluidVariant fluidStack = FluidVariant.fromNbt(nbt.method_10562("variant"));
            if (fluidStack.getFluid() == class_3612.field_15906 || nbt.method_10537("amount") == 0) {
                fluidInfo = class_2561.method_43471("tooltips.touhou_little_maid.tank_backpack.empty_fluid").method_27692(class_124.field_1080);
            } else {
                fluidInfo = class_2561.method_43469("tooltips.touhou_little_maid.tank_backpack.fluid",
                        FluidVariantAttributes.getName(fluidStack),
                        nbt.method_10537("amount") / 81).method_27692(class_124.field_1080);
            }
            tooltip.add(fluidInfo);
        }
    }
}
