package com.github.tartaricacid.touhoulittlemaid.util;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public final class PlaceHelper {
    private PlaceHelper() {
    }

    /**
     * 该坐标是否适合释放女仆
     *
     * @param worldIn 放置的世界
     * @param pos     放置的坐标
     * @return 是否适合放置女仆
     */
    public static boolean notSuitableForPlaceMaid(class_1937 worldIn, class_2338 pos) {
        class_2338 firstPos = pos.method_10084();
        class_2338 secondPos = pos.method_10086(2);
        class_2680 firstBlock = worldIn.method_8320(firstPos);
        class_2680 secondBlock = worldIn.method_8320(secondPos);
        boolean firstBlockHasCollisionBoundingBox = hasCollisionBoundingBox(worldIn, firstBlock, firstPos);
        boolean secondBlockHasCollisionBoundingBox = hasCollisionBoundingBox(worldIn, secondBlock, secondPos);
        return firstBlockHasCollisionBoundingBox || secondBlockHasCollisionBoundingBox;
    }

    /**
     * 该坐标是否适合放置墓碑
     *
     * @param worldIn 放置的世界
     * @param pos     放置的坐标
     * @return 是否适合放置墓碑
     */
    public static boolean notSuitableForPlaceTombstone(class_1937 worldIn, class_2338 pos) {
        class_2680 blockState = worldIn.method_8320(pos);
        return hasCollisionBoundingBox(worldIn, blockState, pos) && !blockState.method_45474();
    }

    /**
     * 该方块是否拥有碰撞体积
     */
    private static boolean hasCollisionBoundingBox(class_1937 worldIn, class_2680 blockState, class_2338 pos) {
        return !blockState.method_26220(worldIn, pos).method_1110();
    }
}
