/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo;

import com.github.tartaricacid.simplebedrockmodel.SimpleBedrockModel;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

@Environment(value=EnvType.CLIENT)
public enum BedrockVersion {
    LEGACY("1.10.0"),
    NEW(">=1.12.0");

    private final VersionPredicate versionRange;

    private BedrockVersion(String version) {
        this.versionRange = BedrockVersion.createFromVersionSpec(version);
    }

    public static boolean isNewVersion(BedrockModelPOJO bedrockModel) {
        Version inputVersion;
        try {
            inputVersion = Version.parse((String)bedrockModel.getFormatVersion());
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
        return BedrockVersion.NEW.versionRange.test((Object)inputVersion);
    }

    public static boolean isLegacyVersion(BedrockModelPOJO bedrockModel) {
        Version inputVersion;
        try {
            inputVersion = Version.parse((String)bedrockModel.getFormatVersion());
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
        return BedrockVersion.LEGACY.versionRange.test((Object)inputVersion);
    }

    private static VersionPredicate createFromVersionSpec(String spec) {
        try {
            return VersionPredicate.parse((String)spec);
        }
        catch (VersionParsingException e) {
            SimpleBedrockModel.LOGGER.fatal("Failed to parse version spec {}", (Object)spec, (Object)e);
            throw new RuntimeException("Failed to parse spec", e);
        }
    }

    public static BedrockVersion getVersion(BedrockModelPOJO pojo) {
        if (BedrockVersion.isNewVersion(pojo)) {
            return NEW;
        }
        if (BedrockVersion.isLegacyVersion(pojo)) {
            return LEGACY;
        }
        throw new RuntimeException("Invalid version for model: " + String.valueOf(pojo));
    }
}

