/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.FaceUVsItem;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public class CubesItem {
    private float[] uv;
    private FaceUVsItem faceUv;
    private boolean mirror = false;
    private boolean hasMirror = false;
    @Expose
    @SerializedName(value="inflate")
    private float inflate;
    @Expose
    @SerializedName(value="size")
    private float[] size;
    @Expose
    @SerializedName(value="origin")
    private float[] origin;
    @Expose
    @SerializedName(value="rotation")
    private float[] rotation;
    @Expose
    @SerializedName(value="pivot")
    private float[] pivot;

    public float[] getUv() {
        return this.uv;
    }

    @Nullable
    public FaceUVsItem getFaceUv() {
        return this.faceUv;
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    public boolean isHasMirror() {
        return this.hasMirror;
    }

    public float getInflate() {
        return this.inflate;
    }

    public float[] getSize() {
        return this.size;
    }

    public float[] getOrigin() {
        return this.origin;
    }

    @Nullable
    public float[] getRotation() {
        return this.rotation;
    }

    @Nullable
    public float[] getPivot() {
        return this.pivot;
    }

    public static class Deserializer
    implements JsonDeserializer<CubesItem> {
        public CubesItem deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            CubesItem cube = (CubesItem)new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().fromJson(json, CubesItem.class);
            if (json.isJsonObject()) {
                JsonPrimitive primitive;
                JsonElement mirrorElement;
                JsonObject obj = json.getAsJsonObject();
                JsonElement uvElement = obj.get("uv");
                if (uvElement.isJsonArray()) {
                    JsonArray array = uvElement.getAsJsonArray();
                    cube.uv = new float[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        cube.uv[i] = array.get(i).getAsFloat();
                    }
                }
                if (uvElement.isJsonObject()) {
                    cube.faceUv = (FaceUVsItem)new Gson().fromJson(uvElement, FaceUVsItem.class);
                }
                if ((mirrorElement = obj.get("mirror")) != null && mirrorElement.isJsonPrimitive() && (primitive = mirrorElement.getAsJsonPrimitive()).isBoolean()) {
                    cube.mirror = primitive.getAsBoolean();
                    cube.hasMirror = true;
                }
            }
            return cube;
        }
    }
}

