/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.llm;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.Client;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public interface LLMClient
extends Client {
    public void chat(List<LLMMessage> var1, LLMConfig var2, ResponseCallback<ResponseChat> var3);

    default public <T> void handleResponse(ResponseCallback<ResponseChat> callback, HttpResponse<String> response, @Nullable Throwable throwable, HttpRequest request, Consumer<T> onSuccess, Type type) {
        if (throwable != null) {
            callback.onFailure(request, throwable, 0);
            return;
        }
        try {
            String string = response.body();
            int statusCode = response.statusCode();
            if (this.isSuccessful(response)) {
                Object message = GSON.fromJson(string, type);
                onSuccess.accept(message);
            } else {
                String message = "HTTP Error Code: %d, Response %s".formatted(statusCode, response);
                callback.onFailure(request, new Throwable(message), 1);
            }
        }
        catch (JsonSyntaxException e) {
            String message = "Exception %s, JSON is: %s".formatted(e.getLocalizedMessage(), response.body());
            callback.onFailure(request, new Throwable(message), 2);
        }
    }
}

