/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.tts.siliconflow;

import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.siliconflow.TTSSiliconflowRequest;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.siliconflow.TTSSiliconflowSite;
import com.google.common.net.MediaType;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

public class TTSSiliconflowClient
implements TTSClient {
    private static final Duration MAX_TIMEOUT = Duration.ofSeconds(20L);
    private final HttpClient httpClient;
    private final TTSSiliconflowSite site;

    public TTSSiliconflowClient(HttpClient httpClient, TTSSiliconflowSite site) {
        this.httpClient = httpClient;
        this.site = site;
    }

    @Override
    public void play(String message, TTSConfig config, ResponseCallback<byte[]> callback) {
        URI url = URI.create(this.site.url());
        String apiKey = this.site.secretKey();
        String voice = config.model();
        TTSSiliconflowRequest request = TTSSiliconflowRequest.create().setInput(message).setModel("FunAudioLLM/CosyVoice2-0.5B").setVoice(voice);
        HttpRequest.Builder builder = HttpRequest.newBuilder().header("Content-Type", MediaType.JSON_UTF_8.toString()).header("Authorization", "Bearer " + apiKey).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)request))).timeout(MAX_TIMEOUT).uri(url);
        this.site.headers().forEach(builder::header);
        HttpRequest httpRequest = builder.build();
        this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofByteArray()).whenComplete((response, throwable) -> this.handleResponse(callback, (HttpResponse<byte[]>)response, (Throwable)throwable, httpRequest));
    }
}

