/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ConditionArmor {
    private static final Pattern ID_PRE_REG = Pattern.compile("^(.+?)\\$(.*?)$");
    private static final Pattern TAG_PRE_REG = Pattern.compile("^(.+?)#(.*?)$");
    private static final String EMPTY = "";
    private final Map<class_1304, List<class_2960>> idTest = Maps.newHashMap();
    private final Map<class_1304, List<class_6862<class_1792>>> tagTest = Maps.newHashMap();

    public void addTest(String name) {
        Matcher matcherId = ID_PRE_REG.matcher(name);
        if (matcherId.find()) {
            class_1304 type = ConditionArmor.getType(matcherId.group(1));
            if (type == null) {
                return;
            }
            String id = matcherId.group(2);
            if (!class_2960.method_20207((String)id)) {
                return;
            }
            class_2960 res = new class_2960(id);
            if (this.idTest.containsKey(type)) {
                this.idTest.get(type).add(res);
            } else {
                this.idTest.put(type, Lists.newArrayList((Object[])new class_2960[]{res}));
            }
            return;
        }
        Matcher matcherTag = TAG_PRE_REG.matcher(name);
        if (matcherTag.find()) {
            class_1304 type = ConditionArmor.getType(matcherTag.group(1));
            if (type == null) {
                return;
            }
            String id = matcherTag.group(2);
            if (!class_2960.method_20207((String)id)) {
                return;
            }
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(id));
            if (this.tagTest.containsKey(type)) {
                this.tagTest.get(type).add((class_6862<class_1792>)tagKey);
            } else {
                this.tagTest.put(type, Lists.newArrayList((Object[])new class_6862[]{tagKey}));
            }
        }
    }

    public String doTest(IMaid maid, class_1304 slot) {
        class_1799 item = maid.asEntity().method_6118(slot);
        if (item.method_7960()) {
            return EMPTY;
        }
        String result = this.doIdTest(maid, slot);
        if (result.isEmpty()) {
            return this.doTagTest(maid, slot);
        }
        return result;
    }

    private String doIdTest(IMaid maid, class_1304 slot) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        if (!this.idTest.containsKey(slot) || this.idTest.get(slot).isEmpty()) {
            return EMPTY;
        }
        List<class_2960> idListTest = this.idTest.get(slot);
        class_1799 item = maid.asEntity().method_6118(slot);
        class_2960 registryName = class_7923.field_41178.method_10221((Object)item.method_7909());
        if (registryName == null) {
            return EMPTY;
        }
        if (idListTest.contains(registryName)) {
            return slot.method_5923() + "$" + String.valueOf(registryName);
        }
        return EMPTY;
    }

    private String doTagTest(IMaid maid, class_1304 slot) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        if (!this.tagTest.containsKey(slot) || this.tagTest.get(slot).isEmpty()) {
            return EMPTY;
        }
        List<class_6862<class_1792>> tagListTest = this.tagTest.get(slot);
        class_1799 item = maid.asEntity().method_6118(slot);
        return tagListTest.stream().filter(arg_0 -> ((class_1799)item).method_31573(arg_0)).findFirst().map(itemTagKey -> slot.method_5923() + "#" + String.valueOf(itemTagKey.comp_327())).orElse(EMPTY);
    }

    @Nullable
    public static class_1304 getType(String type) {
        for (class_1304 equipmentslot : class_1304.values()) {
            if (!equipmentslot.method_5923().equals(type)) continue;
            return equipmentslot;
        }
        return null;
    }
}

