/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.models;

import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.InnerAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.model.PlayerMaidModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1068;
import net.minecraft.class_1308;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4844;

@Environment(value=EnvType.CLIENT)
public final class PlayerMaidModels {
    private static final Cache<String, GameProfile> GAME_PROFILE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private static final GameProfile EMPTY_GAME_PROFILE = new GameProfile(null, "EMPTY");
    private static final PlayerMaidModel PLAYER_MAID_MODEL = new PlayerMaidModel(false);
    private static final PlayerMaidModel PLAYER_MAID_MODEL_SLIM = new PlayerMaidModel(true);
    private static final String SLIM_NAME = "slim";
    private static final List<class_2960> PLAYER_MAID_ANIMATION_RES = Lists.newArrayList((Object[])new class_2960[]{new class_2960("touhou_little_maid", "animation/maid/default/head/default.js"), new class_2960("touhou_little_maid", "animation/maid/default/head/beg.js"), new class_2960("touhou_little_maid", "animation/maid/default/leg/default.js"), new class_2960("touhou_little_maid", "animation/maid/player/arm/default.js"), new class_2960("touhou_little_maid", "animation/maid/default/arm/swing.js"), new class_2960("touhou_little_maid", "animation/maid/player/sit/default.js")});
    private static final class_2960 TEXTURE_ALEX = new class_2960("textures/entity/alex.png");
    private static final List<Object> PLAYER_MAID_ANIMATIONS = Lists.newArrayList();
    private static MaidModelInfo playerMaidInfo;
    private static class_2960 playerSkin;

    public static void reload() {
        PLAYER_MAID_ANIMATIONS.clear();
        for (class_2960 res : PLAYER_MAID_ANIMATION_RES) {
            PLAYER_MAID_ANIMATIONS.add(InnerAnimation.get(res));
        }
        playerMaidInfo = new MaidModelInfo(){

            @Override
            public class_2960 getTexture() {
                return playerSkin;
            }
        };
    }

    public static BedrockModel<class_1308> getPlayerMaidModel(String name) {
        UUID uuid;
        String skinModel;
        String skinModel2;
        Map map;
        GameProfile newProfile = null;
        class_310 minecraft = class_310.method_1551();
        try {
            newProfile = (GameProfile)GAME_PROFILE_CACHE.get((Object)name, () -> {
                THREAD_POOL.submit(() -> {
                    GameProfile profile = new GameProfile(null, name);
                    class_2631.method_11335((GameProfile)profile, profileNew -> {
                        if (profileNew != null) {
                            GAME_PROFILE_CACHE.put((Object)name, profileNew);
                        }
                    });
                });
                return EMPTY_GAME_PROFILE;
            });
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (newProfile != null && ((map = minecraft.method_1582().method_4654(newProfile)).containsKey(MinecraftProfileTexture.Type.SKIN) ? SLIM_NAME.equals(skinModel2 = ((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model")) : SLIM_NAME.equals(skinModel = class_1068.method_4647((UUID)(uuid = class_4844.method_43343((GameProfile)newProfile)))))) {
            return PLAYER_MAID_MODEL_SLIM;
        }
        return PLAYER_MAID_MODEL;
    }

    public static List<Object> getPlayerMaidAnimations() {
        return PLAYER_MAID_ANIMATIONS;
    }

    public static MaidModelInfo getPlayerMaidInfo(String name) {
        playerSkin = PlayerMaidModels.getPlayerSkin(name);
        return playerMaidInfo;
    }

    public static class_2960 getPlayerSkin(String name) {
        GameProfile newProfile = null;
        class_310 minecraft = class_310.method_1551();
        try {
            newProfile = (GameProfile)GAME_PROFILE_CACHE.get((Object)name, () -> {
                THREAD_POOL.submit(() -> {
                    GameProfile profile = new GameProfile(null, name);
                    class_2631.method_11335((GameProfile)profile, profileNew -> {
                        if (profileNew != null) {
                            GAME_PROFILE_CACHE.put((Object)name, profileNew);
                        }
                    });
                });
                return EMPTY_GAME_PROFILE;
            });
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (newProfile != null) {
            Map map = minecraft.method_1582().method_4654(newProfile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                return minecraft.method_1582().method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            }
            UUID uuid = class_4844.method_43343((GameProfile)newProfile);
            return class_1068.method_4648((UUID)uuid);
        }
        return TEXTURE_ALEX;
    }
}

