/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.tooltip;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemMaidTooltip;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import org.apache.commons.lang3.StringUtils;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ClientMaidTooltip
implements class_5684 {
    @Nullable
    private final MaidModelInfo info;
    private final YsmMaidInfo ysmMaidInfo;
    private final class_5250 name;
    private final String customName;

    public ClientMaidTooltip(ItemMaidTooltip tooltip) {
        this.info = CustomPackLoader.MAID_MODELS.getInfo(tooltip.modelId()).orElse(null);
        this.ysmMaidInfo = tooltip.ysmMaidInfo();
        this.name = this.getName(this.info, this.ysmMaidInfo);
        this.customName = tooltip.customName();
    }

    public class_5250 getName(MaidModelInfo info, YsmMaidInfo ysmMaidInfo) {
        if (YsmCompat.isInstalled() && ysmMaidInfo.isYsmModel()) {
            class_5250 name = ysmMaidInfo.name();
            if (name.equals((Object)class_2561.method_43473())) {
                return class_2561.method_43470((String)ysmMaidInfo.modelId());
            }
            return name;
        }
        if (info == null) {
            return class_2561.method_43473();
        }
        return class_2561.method_43471((String)ParseI18n.getI18nKey(info.getName()));
    }

    public int method_32661() {
        return 70;
    }

    public int method_32664(class_327 font) {
        return Math.max(font.method_27525((class_5348)this.name), 50);
    }

    public void method_32666(class_327 font, int pX, int pY, class_332 guiGraphics) {
        EntityMaid maid;
        if (this.info == null) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_5250 customNameComponent = null;
        if (StringUtils.isNotBlank((CharSequence)this.customName)) {
            customNameComponent = class_2561.class_2562.method_10877((String)this.customName);
            if (customNameComponent != null) {
                guiGraphics.method_27535(font, (class_2561)customNameComponent.method_27692(class_124.field_1080), pX, pY + 2, 0xFFFFFF);
            }
        } else {
            guiGraphics.method_27535(font, (class_2561)this.name.method_27692(class_124.field_1080), pX, pY + 2, 0xFFFFFF);
        }
        int width = this.method_32664(font);
        int posX = pX + width / 2;
        int posY = pY + 64;
        double rot = (double)System.currentTimeMillis() / 25.0 % 360.0;
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(rot));
        pose.mul((Quaternionfc)rotation);
        try {
            maid = (EntityMaid)EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> ClientMaidTooltip.lambda$renderImage$1((class_1937)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        EntityCacheUtil.clearMaidDataResidue(maid, false);
        if (StringUtils.isNotBlank((CharSequence)this.customName)) {
            maid.method_5665((class_2561)customNameComponent);
        }
        if (this.info.getEasterEgg() != null) {
            maid.setModelId("touhou_little_maid:easter_egg_model");
        } else {
            maid.setModelId(this.info.getModelId().toString());
        }
        if (YsmCompat.isInstalled() && this.ysmMaidInfo.isYsmModel()) {
            maid.setIsYsmModel(true);
            maid.setYsmModel(this.ysmMaidInfo.modelId(), this.ysmMaidInfo.textureId(), (class_2561)this.ysmMaidInfo.name());
        } else {
            maid.setIsYsmModel(false);
        }
        guiGraphics.method_44379(pX, posY - 50, pX + width, posY);
        class_490.method_48472((class_332)guiGraphics, (int)posX, (int)posY, (int)((int)(25.0f * this.info.getRenderItemScale())), (Quaternionf)pose, null, (class_1309)maid);
        guiGraphics.method_44380();
    }

    private static /* synthetic */ class_1297 lambda$renderImage$1(class_1937 world) throws Exception {
        class_1297 e = EntityMaid.TYPE.method_5883(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
    }
}

