/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.data;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class MaidNumAttachment {
    public static final Codec<MaidNumAttachment> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.INT.fieldOf("num").forGetter(o -> o.num)).apply((Applicative)ins, MaidNumAttachment::new));
    public static final AttachmentType<MaidNumAttachment> TYPE = AttachmentRegistry.builder().initializer(() -> new MaidNumAttachment(0)).persistent(CODEC).copyOnDeath().buildAndRegister(new class_2960("touhou_little_maid", "maid_num"));
    private int num;

    public MaidNumAttachment(int num) {
        this.num = num;
    }

    public boolean canAdd() {
        return this.num + 1 <= this.getMaxNum();
    }

    public void add() {
        this.add(1);
    }

    public void add(int num) {
        this.num = num + this.num <= this.getMaxNum() ? (this.num += num) : this.getMaxNum();
    }

    public void min(int num) {
        this.num = num <= this.num ? (this.num -= num) : 0;
    }

    public void set(int num) {
        this.num = class_3532.method_15340((int)num, (int)0, (int)this.getMaxNum());
    }

    public int getMaxNum() {
        return (Integer)MaidConfig.OWNER_MAX_MAID_NUM.get();
    }

    public int get() {
        return this.num;
    }
}

