/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleDataCollection;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.RandomEmoji;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.WaitingChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class ChatBubbleManager {
    private final EntityMaid maid;

    public ChatBubbleManager(EntityMaid maid) {
        this.maid = maid;
    }

    public void tick() {
        RandomEmoji.tick(this.maid);
        if (this.maid.field_6012 % 5 != 0) {
            return;
        }
        boolean update = this.getChatBubbleDataCollection().update();
        if (update) {
            this.forceUpdateChatBubble();
        }
    }

    public ChatBubbleDataCollection getChatBubbleDataCollection() {
        return (ChatBubbleDataCollection)this.maid.method_5841().method_12789(EntityMaid.getChatBubbleKey());
    }

    @Nullable
    public IChatBubbleData getChatBubble(long key) {
        return this.getChatBubbleDataCollection().get(key);
    }

    public void removeChatBubble(long key) {
        this.getChatBubbleDataCollection().remove(key);
        this.forceUpdateChatBubble();
    }

    public void forceUpdateChatBubble() {
        this.maid.method_5841().method_49743(EntityMaid.getChatBubbleKey(), (Object)this.getChatBubbleDataCollection(), true);
    }

    public long addChatBubble(IChatBubbleData bubble) {
        long key = this.getChatBubbleDataCollection().add(bubble);
        this.forceUpdateChatBubble();
        return key;
    }

    public long addTextChatBubble(String langKey) {
        class_5250 component = class_2561.method_43471((String)langKey);
        return this.addChatBubble(TextChatBubbleData.type2((class_2561)component));
    }

    public long addTextChatBubbleIfTimeout(String langKey, long previousChatBubbleId) {
        ChatBubbleDataCollection collection = this.getChatBubbleDataCollection();
        if (previousChatBubbleId < 0L || !collection.containsKey(previousChatBubbleId)) {
            return this.addTextChatBubble(langKey);
        }
        return previousChatBubbleId;
    }

    public long addThinkingText(String langKey) {
        class_5250 component = class_2561.method_43471((String)langKey).method_27692(class_124.field_1080).method_27692(class_124.field_1056);
        class_2960 icon = new class_2960("touhou_little_maid", "textures/entity/chat_bubble/yinyang_orb.png");
        return this.addChatBubble(WaitingChatBubbleData.create(600, IChatBubbleData.TYPE_2, 0, (class_2561)component, icon));
    }

    public void addLLMChatText(String message, long waitingChatBubbleId) {
        class_5250 component = class_2561.method_43470((String)message);
        TextChatBubbleData textChatBubble = TextChatBubbleData.type2((class_2561)component);
        this.getChatBubbleDataCollection().remove(waitingChatBubbleId);
        this.getChatBubbleDataCollection().add(textChatBubble);
        this.forceUpdateChatBubble();
        class_1309 class_13092 = this.maid.method_35057();
        if (class_13092 instanceof class_3222) {
            class_3222 player = (class_3222)class_13092;
            class_2561 name = this.maid.method_5477();
            class_5250 msg = class_2561.method_43470((String)"<").method_10852(name).method_27693(">").method_10852(class_5244.field_41874).method_27693(message);
            player.method_43496((class_2561)msg.method_27692(class_124.field_1080));
        }
    }
}

