/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.PickType;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2945;
import net.minecraft.class_3532;

public class MaidConfigManager {
    private static final String PICKUP_TAG = "MaidIsPickup";
    private static final String HOME_TAG = "MaidIsHome";
    private static final String RIDEABLE_TAG = "MaidIsRideable";
    private static final String MAID_SUB_CONFIG_TAG = "MaidSubConfig";
    private static final String BACKPACK_SHOW_TAG = "BackpackShow";
    private static final String BACK_ITEM_SHOW_TAG = "BackItemShow";
    private static final String CHATBUBBLE_SHOW_TAG = "ChatBubbleShow";
    private static final String SOUND_FREQ_TAG = "SoundFreq";
    private static final String PICKUP_TYPE_TAG = "PickupType";
    private static final String OPEN_DOOR_TAG = "OpenDoor";
    private static final String OPEN_FENCE_GATE_TAG = "OpenFenceGate";
    private static final String ACTIVE_CLIMBING_TAG = "ActiveClimbing";
    private final class_2945 entityData;

    MaidConfigManager(class_2945 entityData) {
        this.entityData = entityData;
    }

    void defineSynchedData() {
        this.entityData.method_12784(EntityMaid.DATA_PICKUP, (Object)true);
        this.entityData.method_12784(EntityMaid.DATA_HOME_MODE, (Object)false);
        this.entityData.method_12784(EntityMaid.DATA_RIDEABLE, (Object)true);
        this.entityData.method_12784(EntityMaid.BACKPACK_SHOW, (Object)true);
        this.entityData.method_12784(EntityMaid.BACK_ITEM_SHOW, (Object)true);
        this.entityData.method_12784(EntityMaid.CHATBUBBLE_SHOW, (Object)true);
        this.entityData.method_12784(EntityMaid.SOUND_FREQ, (Object)Float.valueOf(1.0f));
        this.entityData.method_12784(EntityMaid.PICKUP_TYPE, (Object)PickType.ALL.ordinal());
        this.entityData.method_12784(EntityMaid.OPEN_DOOR, (Object)true);
        this.entityData.method_12784(EntityMaid.OPEN_FENCE_GATE, (Object)true);
        this.entityData.method_12784(EntityMaid.ACTIVE_CLIMBING, (Object)true);
    }

    void addAdditionalSaveData(class_2487 compound) {
        compound.method_10556(PICKUP_TAG, this.isPickup());
        compound.method_10556(HOME_TAG, this.isHomeModeEnable());
        compound.method_10556(RIDEABLE_TAG, this.isRideable());
        class_2487 maidSubConfig = new class_2487();
        maidSubConfig.method_10556(BACKPACK_SHOW_TAG, this.isShowBackpack());
        maidSubConfig.method_10556(BACK_ITEM_SHOW_TAG, this.isShowBackItem());
        maidSubConfig.method_10556(CHATBUBBLE_SHOW_TAG, this.isChatBubbleShow());
        maidSubConfig.method_10548(SOUND_FREQ_TAG, this.getSoundFreq());
        maidSubConfig.method_10569(PICKUP_TYPE_TAG, this.getPickupType().ordinal());
        maidSubConfig.method_10556(OPEN_DOOR_TAG, this.isOpenDoor());
        maidSubConfig.method_10556(OPEN_FENCE_GATE_TAG, this.isOpenFenceGate());
        maidSubConfig.method_10556(ACTIVE_CLIMBING_TAG, this.isActiveClimbing());
        compound.method_10566(MAID_SUB_CONFIG_TAG, (class_2520)maidSubConfig);
    }

    void readAdditionalSaveData(class_2487 compound) {
        if (compound.method_10573(PICKUP_TAG, 1)) {
            this.setPickup(compound.method_10577(PICKUP_TAG));
        }
        if (compound.method_10573(HOME_TAG, 1)) {
            this.setHomeModeEnable(compound.method_10577(HOME_TAG));
        }
        if (compound.method_10573(RIDEABLE_TAG, 1)) {
            this.setRideable(compound.method_10577(RIDEABLE_TAG));
        }
        if (compound.method_10573(MAID_SUB_CONFIG_TAG, 10)) {
            class_2487 maidSubConfig = compound.method_10562(MAID_SUB_CONFIG_TAG);
            if (maidSubConfig.method_10545(BACKPACK_SHOW_TAG)) {
                this.setShowBackpack(maidSubConfig.method_10577(BACKPACK_SHOW_TAG));
            }
            if (maidSubConfig.method_10545(BACK_ITEM_SHOW_TAG)) {
                this.setShowBackItem(maidSubConfig.method_10577(BACK_ITEM_SHOW_TAG));
            }
            if (maidSubConfig.method_10545(CHATBUBBLE_SHOW_TAG)) {
                this.setChatBubbleShow(maidSubConfig.method_10577(CHATBUBBLE_SHOW_TAG));
            }
            if (maidSubConfig.method_10545(SOUND_FREQ_TAG)) {
                this.setSoundFreq(maidSubConfig.method_10583(SOUND_FREQ_TAG));
            }
            if (maidSubConfig.method_10545(PICKUP_TYPE_TAG)) {
                this.setPickupType(PickType.values()[maidSubConfig.method_10550(PICKUP_TYPE_TAG)]);
            }
            if (maidSubConfig.method_10545(OPEN_DOOR_TAG)) {
                this.setOpenDoor(maidSubConfig.method_10577(OPEN_DOOR_TAG));
            }
            if (maidSubConfig.method_10545(OPEN_FENCE_GATE_TAG)) {
                this.setOpenFenceGate(maidSubConfig.method_10577(OPEN_FENCE_GATE_TAG));
            }
            if (maidSubConfig.method_10545(ACTIVE_CLIMBING_TAG)) {
                this.setActiveClimbing(maidSubConfig.method_10577(ACTIVE_CLIMBING_TAG));
            }
        }
    }

    boolean isHomeModeEnable() {
        return (Boolean)this.entityData.method_12789(EntityMaid.DATA_HOME_MODE);
    }

    void setHomeModeEnable(boolean enable) {
        this.entityData.method_12778(EntityMaid.DATA_HOME_MODE, (Object)enable);
    }

    boolean isPickup() {
        return (Boolean)this.entityData.method_12789(EntityMaid.DATA_PICKUP);
    }

    void setPickup(boolean isPickup) {
        this.entityData.method_12778(EntityMaid.DATA_PICKUP, (Object)isPickup);
    }

    boolean isRideable() {
        return (Boolean)this.entityData.method_12789(EntityMaid.DATA_RIDEABLE);
    }

    void setRideable(boolean rideable) {
        this.entityData.method_12778(EntityMaid.DATA_RIDEABLE, (Object)rideable);
    }

    public SyncNetwork getSyncNetwork() {
        return new SyncNetwork(this.isShowBackpack(), this.isShowBackItem(), this.isChatBubbleShow(), this.getSoundFreq(), this.getPickupType(), this.isOpenDoor(), this.isOpenFenceGate(), this.isActiveClimbing());
    }

    public boolean isShowBackpack() {
        return (Boolean)this.entityData.method_12789(EntityMaid.BACKPACK_SHOW);
    }

    public void setShowBackpack(boolean show) {
        this.entityData.method_12778(EntityMaid.BACKPACK_SHOW, (Object)show);
    }

    public boolean isShowBackItem() {
        return (Boolean)this.entityData.method_12789(EntityMaid.BACK_ITEM_SHOW);
    }

    public void setShowBackItem(boolean show) {
        this.entityData.method_12778(EntityMaid.BACK_ITEM_SHOW, (Object)show);
    }

    public boolean isChatBubbleShow() {
        return (Boolean)this.entityData.method_12789(EntityMaid.CHATBUBBLE_SHOW);
    }

    public void setChatBubbleShow(boolean show) {
        this.entityData.method_12778(EntityMaid.CHATBUBBLE_SHOW, (Object)show);
    }

    public float getSoundFreq() {
        return ((Float)this.entityData.method_12789(EntityMaid.SOUND_FREQ)).floatValue();
    }

    public void setSoundFreq(float freq) {
        this.entityData.method_12778(EntityMaid.SOUND_FREQ, (Object)Float.valueOf(class_3532.method_15363((float)freq, (float)0.0f, (float)1.0f)));
    }

    public PickType getPickupType() {
        int index = (Integer)this.entityData.method_12789(EntityMaid.PICKUP_TYPE);
        return PickType.values()[index];
    }

    public void setPickupType(PickType type) {
        this.entityData.method_12778(EntityMaid.PICKUP_TYPE, (Object)type.ordinal());
    }

    public boolean isOpenDoor() {
        return (Boolean)this.entityData.method_12789(EntityMaid.OPEN_DOOR);
    }

    public void setOpenDoor(boolean openDoor) {
        this.entityData.method_12778(EntityMaid.OPEN_DOOR, (Object)openDoor);
    }

    public boolean isOpenFenceGate() {
        return (Boolean)this.entityData.method_12789(EntityMaid.OPEN_FENCE_GATE);
    }

    public void setOpenFenceGate(boolean openFenceGate) {
        this.entityData.method_12778(EntityMaid.OPEN_FENCE_GATE, (Object)openFenceGate);
    }

    public boolean isActiveClimbing() {
        return (Boolean)this.entityData.method_12789(EntityMaid.ACTIVE_CLIMBING);
    }

    public void setActiveClimbing(boolean activeClimbing) {
        this.entityData.method_12778(EntityMaid.ACTIVE_CLIMBING, (Object)activeClimbing);
    }

    public static final class SyncNetwork {
        private boolean showBackpack;
        private boolean showBackItem;
        private boolean showChatBubble;
        private float soundFreq;
        private PickType pickType;
        private boolean openDoor;
        private boolean openFenceGate;
        private boolean activeClimbing;

        public SyncNetwork(boolean showBackpack, boolean showBackItem, boolean showChatBubble, float soundFreq, PickType pickType, boolean openDoor, boolean openFenceGate, boolean activeClimbing) {
            this.showBackpack = showBackpack;
            this.showBackItem = showBackItem;
            this.showChatBubble = showChatBubble;
            this.soundFreq = soundFreq;
            this.pickType = pickType;
            this.openDoor = openDoor;
            this.openFenceGate = openFenceGate;
            this.activeClimbing = activeClimbing;
        }

        public static void encode(SyncNetwork message, class_2540 buf) {
            buf.writeBoolean(message.showBackpack);
            buf.writeBoolean(message.showBackItem);
            buf.writeBoolean(message.showChatBubble);
            buf.writeFloat(message.soundFreq);
            buf.method_10817((Enum)message.pickType);
            buf.writeBoolean(message.openDoor);
            buf.writeBoolean(message.openFenceGate);
            buf.writeBoolean(message.activeClimbing);
        }

        public static SyncNetwork decode(class_2540 buf) {
            boolean showBackpack = buf.readBoolean();
            boolean showBackItem = buf.readBoolean();
            boolean showChatBubble = buf.readBoolean();
            float soundFreq = buf.readFloat();
            PickType pickType = (PickType)buf.method_10818(PickType.class);
            boolean openDoor = buf.readBoolean();
            boolean openFenceGate = buf.readBoolean();
            boolean activeClimbing = buf.readBoolean();
            return new SyncNetwork(showBackpack, showBackItem, showChatBubble, soundFreq, pickType, openDoor, openFenceGate, activeClimbing);
        }

        public static void handle(SyncNetwork message, EntityMaid maid) {
            MaidConfigManager configManager = maid.getConfigManager();
            configManager.setShowBackpack(message.showBackpack);
            configManager.setShowBackItem(message.showBackItem);
            configManager.setChatBubbleShow(message.showChatBubble);
            configManager.setSoundFreq(message.soundFreq);
            configManager.setPickupType(message.pickType);
            configManager.setOpenDoor(message.openDoor);
            configManager.setOpenFenceGate(message.openFenceGate);
            configManager.setActiveClimbing(message.activeClimbing);
        }

        public boolean showBackpack() {
            return this.showBackpack;
        }

        public boolean showBackItem() {
            return this.showBackItem;
        }

        public boolean showChatBubble() {
            return this.showChatBubble;
        }

        public float soundFreq() {
            return this.soundFreq;
        }

        public PickType pickType() {
            return this.pickType;
        }

        public boolean openDoor() {
            return this.openDoor;
        }

        public boolean openFenceGate() {
            return this.openFenceGate;
        }

        public boolean activeClimbing() {
            return this.activeClimbing;
        }

        public void setShowBackpack(boolean showBackpack) {
            this.showBackpack = showBackpack;
        }

        public void setShowBackItem(boolean showBackItem) {
            this.showBackItem = showBackItem;
        }

        public void setShowChatBubble(boolean showChatBubble) {
            this.showChatBubble = showChatBubble;
        }

        public void setSoundFreq(float soundFreq) {
            this.soundFreq = class_3532.method_15363((float)soundFreq, (float)0.0f, (float)1.0f);
        }

        public void setPickType(PickType pickType) {
            this.pickType = pickType;
        }

        public void setOpenDoor(boolean openDoor) {
            this.openDoor = openDoor;
        }

        public void setOpenFenceGate(boolean openFenceGate) {
            this.openFenceGate = openFenceGate;
        }

        public void setActiveClimbing(boolean activeClimbing) {
            this.activeClimbing = activeClimbing;
        }
    }
}

