/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.message.CheckScheduleMessage;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4215;
import net.minecraft.server.MinecraftServer;

public class MaidConfigMessage {
    public static final class_2960 ID = TouhouLittleMaidFabric.getResourceLocation("maid_config");

    public static class_2540 encode(int id, boolean home, boolean pick, boolean ride, MaidSchedule schedule) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        buf.writeBoolean(home);
        buf.writeBoolean(pick);
        buf.writeBoolean(ride);
        buf.method_10817((Enum)schedule);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int id = buf.readInt();
        boolean home = buf.readBoolean();
        boolean pick = buf.readBoolean();
        boolean ride = buf.readBoolean();
        MaidSchedule schedule = (MaidSchedule)buf.method_10818(MaidSchedule.class);
        server.execute(() -> {
            EntityMaid maid;
            class_1297 entity = player.field_6002.method_8469(id);
            if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).method_6171((class_1309)player)) {
                if (maid.isHomeModeEnable() != home) {
                    MaidConfigMessage.handleHome(id, home, pick, ride, schedule, player, maid);
                }
                if (maid.isPickup() != pick) {
                    maid.setPickup(pick);
                }
                if (maid.isRideable() != ride) {
                    maid.setRideable(ride);
                    class_1297 vehicle = maid.method_5854();
                    if (!ride && vehicle != null && !MaidConfigMessage.isStopRideBlocklist(vehicle)) {
                        maid.method_5848();
                    }
                }
                if (maid.getSchedule() != schedule) {
                    class_1309 patt0$temp;
                    maid.setSchedule(schedule);
                    maid.getSchedulePos().restrictTo(maid);
                    if (maid.isHomeModeEnable()) {
                        class_4215.method_24561((class_1309)maid, (class_2338)maid.method_18412(), (float)0.7f, (int)3);
                    }
                    if ((patt0$temp = maid.method_35057()) instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)patt0$temp;
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, "switch_schedule");
                    }
                }
            }
        });
    }

    private static boolean isStopRideBlocklist(class_1297 vehicle) {
        EntityBroom broom;
        boolean isSit = vehicle instanceof EntitySit;
        boolean isBroom = vehicle instanceof EntityBroom && !(broom = (EntityBroom)vehicle).method_24828();
        return isSit || isBroom;
    }

    private static void handleHome(int id, boolean home, boolean pick, boolean ride, MaidSchedule schedule, class_3222 player, EntityMaid maid) {
        if (home) {
            SchedulePos schedulePos = maid.getSchedulePos();
            if (schedulePos.isConfigured()) {
                class_2960 dimension = schedulePos.getDimension();
                if (!dimension.equals((Object)maid.field_6002.method_27983().method_29177())) {
                    class_2540 buf = CheckScheduleMessage.encode("message.touhou_little_maid.check_schedule_pos.dimension");
                    ServerPlayNetworking.send((class_3222)player, (class_2960)CheckScheduleMessage.ID, (class_2540)buf);
                    return;
                }
                class_2338 nearestPos = schedulePos.getNearestPos(maid);
                if (nearestPos != null && nearestPos.method_10262((class_2382)maid.method_24515()) > 1024.0) {
                    class_2540 buf = CheckScheduleMessage.encode("message.touhou_little_maid.check_schedule_pos.too_far");
                    ServerPlayNetworking.send((class_3222)player, (class_2960)CheckScheduleMessage.ID, (class_2540)buf);
                    return;
                }
            }
            schedulePos.setHomeModeEnable(maid, maid.method_24515());
        } else {
            maid.method_18408(class_2338.field_10980, (Integer)MaidConfig.MAID_NON_HOME_RANGE.get());
        }
        maid.setHomeModeEnable(home);
    }
}

