package cn.sh1rocu.touhoulittlemaid.api.mixin;

import cn.sh1rocu.touhoulittlemaid.api.extension.ILootContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_47;

public class LootCollector implements Consumer<class_1799> {
    private final Consumer<class_1799> wrapped;
    private final ObjectArrayList<class_1799> stacks = new ObjectArrayList<>();

    public LootCollector(Consumer<class_1799> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void accept(class_1799 stack) {
        this.stacks.add(stack);
    }

    public void finish(class_2960 tableId, class_47 ctx) {
        setId(tableId, stacks, ctx).forEach(wrapped);
        stacks.clear();
    }

    private static ObjectArrayList<class_1799> setId(class_2960 lootTableId, ObjectArrayList<class_1799> generatedLoot, class_47 context) {
        ((ILootContext) context).tlm$setQueriedLootTableId(lootTableId);
        return generatedLoot;
    }
}