package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import java.util.function.BiPredicate;
import net.minecraft.class_1308;
import net.minecraft.class_1690;
import net.minecraft.class_4050;

public class AnimationRegister {
    private static final double MIN_SPEED = 0.05;

    public static void registerAnimationState() {
        register("death", ILoopType.EDefaultLoopTypes.PLAY_ONCE, Priority.HIGHEST, (maid, event) -> maid.asEntity().method_29504());
        register("sleep", Priority.HIGHEST, (maid, event) -> maid.asEntity().method_18376() == class_4050.field_18078);
        register("swim", Priority.HIGHEST, (maid, event) -> maid.asEntity().method_20232());

        register("ladder_up", Priority.HIGHEST, (maid, event) -> maid.onClimbable() && getVerticalSpeed(maid) > 0);
        register("ladder_stillness", Priority.HIGHEST, (maid, event) -> maid.onClimbable() && getVerticalSpeed(maid) == 0);
        register("ladder_down", Priority.HIGHEST, (maid, event) -> maid.onClimbable() && getVerticalSpeed(maid) < 0);

        register("gomoku", Priority.HIGH, (maid, event) -> sitInJoy(maid, Type.GOMOKU));
        register("bookshelf", Priority.HIGH, (maid, event) -> sitInJoy(maid, Type.BOOKSHELF));
        register("computer", Priority.HIGH, (maid, event) -> sitInJoy(maid, Type.COMPUTER));
        register("keyboard", Priority.HIGH, (maid, event) -> sitInJoy(maid, Type.KEYBOARD));
        register("picnic", Priority.HIGH, (maid, event) -> sitInJoy(maid, Type.ON_HOME_MEAL));

        register("boat", Priority.HIGH, (maid, event) -> maid.asEntity().method_5854() instanceof class_1690);
        register("chair", Priority.HIGH, (maid, event) -> maid.asEntity().method_5765());
        register("sit", Priority.HIGH, (maid, event) -> maid.isMaidInSittingPose());

        register("swim_stand", Priority.NORMAL, (maid, event) -> maid.asEntity().method_5799());
        register("attacked", ILoopType.EDefaultLoopTypes.PLAY_ONCE, Priority.NORMAL, (maid, event) -> maid.asEntity().field_6235 > 0);
        register("jump", Priority.NORMAL, (maid, event) -> !maid.asEntity().method_24828() && !maid.asEntity().method_5799());

        register("run", Priority.LOW, (maid, event) -> maid.asEntity().method_24828() && maid.asEntity().method_5624());
        register("walk", Priority.LOW, (maid, event) -> maid.asEntity().method_24828() && event.getLimbSwingAmount() > MIN_SPEED);

        register("idle", Priority.LOWEST, (maid, event) -> true);
    }

    private static boolean sitInJoy(IMaid maid, Type type) {
        return maid.asEntity().method_5854() instanceof EntitySit sit && sit.getJoyType().equals(type.getTypeName());
    }

    private static void register(String animationName, ILoopType loopType, int priority, BiPredicate<IMaid, AnimationEvent<?>> predicate) {
        AnimationManager manager = AnimationManager.getInstance();
        manager.register(new AnimationState(animationName, loopType, priority, predicate));
    }

    private static void register(String animationName, int priority, BiPredicate<IMaid, AnimationEvent<?>> predicate) {
        register(animationName, ILoopType.EDefaultLoopTypes.LOOP, priority, predicate);
    }

    private static float getVerticalSpeed(IMaid maid) {
        class_1308 entity = maid.asEntity();
        return 20 * (float) (entity.method_19538().field_1351 - entity.field_6036);
    }
}