package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.WirelessIOSlotButton;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.network.message.WirelessIOSlotConfigMessage;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;

import static com.github.tartaricacid.touhoulittlemaid.util.BytesBooleansConvert.booleans2Bytes;
import static com.github.tartaricacid.touhoulittlemaid.util.BytesBooleansConvert.bytes2Booleans;

public class WirelessIOConfigSlotGui extends class_437 {
    private static final class_2960 SLOT = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/wireless_io_slot_config.png");
    private static final int SLOT_NUM = 38;
    private final boolean[] configData;
    protected int imageWidth = 155;
    protected int imageHeight = 160;
    protected int leftPos;
    protected int topPos;

    protected WirelessIOConfigSlotGui(class_1799 wirelessIO) {
        super(class_2561.method_43470("Wireless IO Config Slot GUI"));
        configData = bytes2Booleans(ItemWirelessIO.getSlotConfig(wirelessIO), SLOT_NUM);
    }

    @Override
    protected void method_25426() {
        this.method_37067();

        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;

        int index = 0;
        for (int col = 0; col < 6; col++) {
            WirelessIOSlotButton button = new WirelessIOSlotButton(index, leftPos + 8 + 18 * col, topPos + 8, 16, 16, configData);
            button.initTextureValues(158, 0, 16, 16, SLOT);
            method_37063(button);
            index++;
        }

        for (int col = 0; col < 6; col++) {
            WirelessIOSlotButton button = new WirelessIOSlotButton(index, leftPos + 8 + 18 * col, topPos + 30, 16, 16, configData);
            button.initTextureValues(158, 0, 16, 16, SLOT);
            method_37063(button);
            index++;
        }

        for (int row = 0; row < 2; row++) {
            for (int col = 0; col < 6; col++) {
                WirelessIOSlotButton button = new WirelessIOSlotButton(index, leftPos + 8 + 18 * col, topPos + 53 + 18 * row, 16, 16, configData);
                button.initTextureValues(158, 0, 16, 16, SLOT);
                method_37063(button);
                index++;
            }
        }

        for (int row = 0; row < 2; row++) {
            for (int col = 0; col < 6; col++) {
                WirelessIOSlotButton button = new WirelessIOSlotButton(index, leftPos + 8 + 18 * col, topPos + 94 + 18 * row, 16, 16, configData);
                button.initTextureValues(158, 0, 16, 16, SLOT);
                method_37063(button);
                index++;
            }
        }

        for (int row = 0; row < 2; row++) {
            WirelessIOSlotButton button = new WirelessIOSlotButton(index, leftPos + 131, topPos + 8 + 18 * row, 16, 16, configData);
            button.initTextureValues(158, 0, 16, 16, SLOT);
            method_37063(button);
            index++;
        }

        class_4185 confirm = class_4185.method_46430(class_2561.method_43471("gui.done"), b -> ClientPlayNetworking.send(WirelessIOSlotConfigMessage.ID,
                        WirelessIOSlotConfigMessage.encode(booleans2Bytes(this.configData))))
                .method_46433(leftPos, topPos + 140).method_46437(60, 20).method_46431();
        class_4185 cancel = class_4185.method_46430(class_2561.method_43471("gui.cancel"), b ->
                        ClientPlayNetworking.send(WirelessIOSlotConfigMessage.ID, WirelessIOSlotConfigMessage.encode()))
                .method_46433(leftPos + 62, topPos + 140).method_46437(60, 20).method_46431();
        method_37063(confirm);
        method_37063(cancel);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderBg(class_332 guiGraphics) {
        this.method_25420(guiGraphics);
        guiGraphics.method_25302(SLOT, leftPos, topPos, 0, 0, imageWidth, imageHeight);
    }
}
