package com.github.tartaricacid.touhoulittlemaid.client.init;

import com.github.tartaricacid.touhoulittlemaid.client.tooltip.ClientBoardStateTooltip;
import com.github.tartaricacid.touhoulittlemaid.client.tooltip.ClientItemContainerTooltip;
import com.github.tartaricacid.touhoulittlemaid.client.tooltip.ClientMaidTooltip;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.BoardStateTooltip;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemContainerTooltip;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemMaidTooltip;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_5632;
import net.minecraft.class_5684;

@Environment(EnvType.CLIENT)
public class InitClientTooltip {
    public static class_5684 onRegisterClientTooltip(class_5632 component) {
        if (component instanceof ItemMaidTooltip itemMaidTooltip) {
            return new ClientMaidTooltip(itemMaidTooltip);
        }
        if (component instanceof ItemContainerTooltip itemContainerTooltip) {
            return new ClientItemContainerTooltip(itemContainerTooltip);
        }
        if (component instanceof BoardStateTooltip boardStateTooltip) {
            return new ClientBoardStateTooltip(boardStateTooltip);
        }
        return null;
    }
}
